/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ListMessageSplitter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.util.mock.PayloadClassConstraint;

public class FilterListMessageSplitterRouterTestCase
extends AbstractMuleTestCase {
    public void testMessageSplitterRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)FilterListMessageSplitterRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint endpoint2 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint endpoint3 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        ListMessageSplitter router = this.createObject(ListMessageSplitter.class);
        router.setFilter((Filter)new PayloadTypeFilter(List.class));
        router.addEndpoint(endpoint1);
        router.addEndpoint(endpoint2);
        router.addEndpoint(endpoint3);
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(new Apple());
        payload.add(new Apple());
        payload.add(new Orange());
        payload.add(new String());
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        FilterListMessageSplitterRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint1)));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint1)));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(Orange.class), (Constraint)C.eq((Object)endpoint2)));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(String.class), (Constraint)C.eq((Object)endpoint3)));
        router.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
        endpoint1 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1?synchronous=true", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        endpoint2 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2?synchronous=true", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        endpoint3 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3?synchronous=true");
        router = this.createObject(ListMessageSplitter.class);
        router.setFilter((Filter)new PayloadTypeFilter(List.class));
        router.addEndpoint(endpoint1);
        router.addEndpoint(endpoint2);
        router.addEndpoint(endpoint3);
        message = new DefaultMuleMessage(payload, muleContext);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint1)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint1)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(Orange.class), (Constraint)C.eq((Object)endpoint2)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(String.class), (Constraint)C.eq((Object)endpoint3)), (Object)message);
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)session.proxy());
        FilterListMessageSplitterRouterTestCase.assertNotNull((Object)result);
        FilterListMessageSplitterRouterTestCase.assertTrue((boolean)(result.getPayload() instanceof List));
        FilterListMessageSplitterRouterTestCase.assertEquals((int)((List)result.getPayload()).size(), (int)4);
        session.verify();
    }
}

