/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.Router;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.transport.DefaultMessageAdapter;

public class OutboundMessageRouterTestCase
extends AbstractMuleTestCase {
    public void testOutboundMessageRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)OutboundMessageRouterTestCase.getTestService());
        DefaultOutboundRouterCollection messageRouter = this.createObject(DefaultOutboundRouterCollection.class);
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundMessageRouterTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        OutboundEndpoint endpoint1 = OutboundMessageRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?synchronous=false");
        OutboundMessageRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = OutboundMessageRouterTestCase.getTestOutboundEndpoint("Test2Provider");
        OutboundMessageRouterTestCase.assertNotNull((Object)endpoint2);
        FilteringOutboundRouter router1 = new FilteringOutboundRouter();
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router1.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router1.setEndpoints(endpoints);
        FilteringOutboundRouter router2 = new FilteringOutboundRouter();
        PayloadTypeFilter filter2 = new PayloadTypeFilter();
        filter2.setExpectedType(Exception.class);
        router2.setFilter((Filter)filter2);
        endpoints = new ArrayList();
        endpoints.add(endpoint2);
        router2.setEndpoints(endpoints);
        messageRouter.addRouter((Router)router1);
        OutboundMessageRouterTestCase.assertEquals((int)1, (int)messageRouter.getRouters().size());
        OutboundMessageRouterTestCase.assertNotNull((Object)messageRouter.removeRouter((Router)router1));
        OutboundMessageRouterTestCase.assertEquals((int)0, (int)messageRouter.getRouters().size());
        ArrayList<FilteringOutboundRouter> list = new ArrayList<FilteringOutboundRouter>();
        list.add(router1);
        list.add(router2);
        messageRouter.setRouters(list);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        session.expect("dispatchEvent", C.eq((Object)message, (Object)endpoint1));
        messageRouter.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
        message = new DefaultMuleMessage((Object)new IllegalArgumentException(), muleContext);
        session.expectAndReturn("getService", (Object)OutboundMessageRouterTestCase.getTestService());
        session.expect("dispatchEvent", C.eq((Object)message, (Object)endpoint2));
        messageRouter.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
        FilteringOutboundRouter router3 = new FilteringOutboundRouter();
        router3.setFilter((Filter)new PayloadTypeFilter(Object.class));
        endpoints = new ArrayList();
        endpoints.add(endpoint2);
        router3.setEndpoints(endpoints);
        messageRouter.addRouter((Router)router3);
        message = new DefaultMuleMessage((Object)"testing multiple routing", muleContext);
        session.expectAndReturn("getService", (Object)OutboundMessageRouterTestCase.getTestService());
        session.expectAndReturn("getService", (Object)OutboundMessageRouterTestCase.getTestService());
        session.expect("dispatchEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint1)));
        session.expect("dispatchEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint2)));
        messageRouter.setMatchAll(true);
        messageRouter.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
    }

    public void testRouterWithCatchAll() throws Exception {
        final int[] count1 = new int[]{0};
        final int[] count2 = new int[]{0};
        final int[] catchAllCount = new int[]{0};
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        FilteringOutboundRouter filterRouter1 = new FilteringOutboundRouter(){

            public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
                count1[0] = count1[0] + 1;
                return message;
            }
        };
        FilteringOutboundRouter filterRouter2 = new FilteringOutboundRouter(){

            public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
                count2[0] = count2[0] + 1;
                return message;
            }
        };
        filterRouter1.setFilter((Filter)new PayloadTypeFilter(Exception.class));
        filterRouter2.setFilter((Filter)new PayloadTypeFilter(StringBuffer.class));
        messageRouter.addRouter((Router)filterRouter1);
        messageRouter.addRouter((Router)filterRouter2);
        AbstractCatchAllStrategy strategy = new AbstractCatchAllStrategy(){

            public MuleMessage doCatchMessage(MuleMessage message, MuleSession session) throws RoutingException {
                catchAllCount[0] = catchAllCount[0] + 1;
                return null;
            }
        };
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)strategy);
        MuleSession session = OutboundMessageRouterTestCase.getTestSession(OutboundMessageRouterTestCase.getTestService(), muleContext);
        messageRouter.route((MuleMessage)new DefaultMuleMessage((Object)"hello", muleContext), session);
        OutboundMessageRouterTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        OutboundMessageRouterTestCase.assertEquals((int)0, (int)count1[0]);
        OutboundMessageRouterTestCase.assertEquals((int)0, (int)count2[0]);
        messageRouter.route((MuleMessage)new DefaultMuleMessage((Object)new StringBuffer(), muleContext), session);
        OutboundMessageRouterTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        OutboundMessageRouterTestCase.assertEquals((int)0, (int)count1[0]);
        OutboundMessageRouterTestCase.assertEquals((int)1, (int)count2[0]);
        messageRouter.route((MuleMessage)new DefaultMuleMessage((Object)new Exception(), muleContext), session);
        OutboundMessageRouterTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        OutboundMessageRouterTestCase.assertEquals((int)1, (int)count1[0]);
        OutboundMessageRouterTestCase.assertEquals((int)1, (int)count2[0]);
    }

    public void testCorrelation() throws Exception {
        FilteringOutboundRouter filterRouter = new FilteringOutboundRouter();
        MuleSession session = OutboundMessageRouterTestCase.getTestSession(OutboundMessageRouterTestCase.getTestService(), muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new DefaultMessageAdapter((Object)new StringBuffer()), muleContext);
        OutboundEndpoint endpoint = OutboundMessageRouterTestCase.getTestOutboundEndpoint("test");
        filterRouter.setMessageProperties(session, (MuleMessage)message, endpoint);
        OutboundMessageRouterTestCase.assertNotNull((Object)message.getCorrelationId());
    }
}

