/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.routing.outbound.StaticRecipientList;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class StaticRecipientListRouterTestCase
extends AbstractMuleTestCase {
    public void testRecipientListRouterAsync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)StaticRecipientListRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = StaticRecipientListRouterTestCase.getTestOutboundEndpoint("Test1Provider");
        StaticRecipientListRouterTestCase.assertNotNull((Object)endpoint1);
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("test://recipient1");
        recipients.add("test://recipient2");
        StaticRecipientList router = this.createObject(StaticRecipientList.class);
        router.setRecipients(recipients);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setEndpoints(endpoints);
        router.setMuleContext(muleContext);
        StaticRecipientListRouterTestCase.assertEquals((int)2, (int)router.getRecipients().size());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        StaticRecipientListRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        session.expect("dispatchEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.isA(ImmutableEndpoint.class)));
        session.expect("dispatchEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.isA(ImmutableEndpoint.class)));
        router.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
    }

    public void testRecipientListRouterSync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)StaticRecipientListRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = StaticRecipientListRouterTestCase.getTestOutboundEndpoint("Test1Provider");
        StaticRecipientListRouterTestCase.assertNotNull((Object)endpoint1);
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("test://recipient1?synchronous=true");
        recipients.add("test://recipient2?synchronous=true");
        StaticRecipientList router = this.createObject(StaticRecipientList.class);
        router.setRecipients(recipients);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setEndpoints(endpoints);
        router.setMuleContext(muleContext);
        StaticRecipientListRouterTestCase.assertEquals((int)2, (int)router.getRecipients().size());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        StaticRecipientListRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        message = new DefaultMuleMessage((Object)"test event", muleContext);
        router.getRecipients().add("test://recipient3?synchronous=true");
        session.expectAndReturn("sendEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.isA(ImmutableEndpoint.class)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.isA(ImmutableEndpoint.class)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.isA(ImmutableEndpoint.class)), (Object)message);
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)session.proxy());
        StaticRecipientListRouterTestCase.assertNotNull((Object)result);
        StaticRecipientListRouterTestCase.assertTrue((boolean)(result.getPayload() instanceof List));
        StaticRecipientListRouterTestCase.assertEquals((int)3, (int)((List)result.getPayload()).size());
        session.verify();
    }

    public void testBadRecipientListRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        OutboundEndpoint endpoint1 = StaticRecipientListRouterTestCase.getTestOutboundEndpoint("Test1Provider");
        StaticRecipientListRouterTestCase.assertNotNull((Object)endpoint1);
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("malformed-endpointUri-recipient1");
        StaticRecipientList router = this.createObject(StaticRecipientList.class);
        router.setRecipients(recipients);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setEndpoints(endpoints);
        StaticRecipientListRouterTestCase.assertEquals((int)1, (int)router.getRecipients().size());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        StaticRecipientListRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        try {
            router.route((MuleMessage)message, (MuleSession)session.proxy());
            StaticRecipientListRouterTestCase.fail((String)"Should not allow malformed endpointUri");
        }
        catch (Exception e) {
            // empty catch block
        }
        session.verify();
    }
}

