/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.mule.tck.ParameterizedConfiguration;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleParameterized
extends Parameterized {
    private static ArrayList<String> excludedTests = new ArrayList();
    private final ArrayList<Runner> muleRunners = new ArrayList();
    private static Filter excludeFilter = new Filter(){

        public boolean shouldRun(Description description) {
            for (int i = 0; i < excludedTests.size(); ++i) {
                if (!description.toString().contains((CharSequence)excludedTests.get(i))) continue;
                return false;
            }
            return true;
        }

        public String describe() {
            return "excludes tests from mule-test-exclusions.txt";
        }
    };

    public MuleParameterized(Class<?> klass) throws Throwable {
        super(klass);
        List runners = super.getChildren();
        List<Object[]> parametersList = this.getParametersList(this.getTestClass());
        for (int i = 0; i < parametersList.size(); ++i) {
            Object parameter = parametersList.get(i)[0];
            if (!(parameter instanceof ParameterizedConfiguration)) {
                throw new IllegalArgumentException("Parameters for Mule test classes should implement the ParameterizedConfiguration interface");
            }
            ((ParameterizedConfiguration)parameter).initialise(this.getTestClass().getJavaClass());
            if (!((ParameterizedConfiguration)parameter).isEnabled()) continue;
            this.muleRunners.add((Runner)runners.get(i));
        }
        this.getExcluded();
        try {
            this.filter(excludeFilter);
        }
        catch (NoTestsRemainException e) {
            // empty catch block
        }
    }

    protected List<Runner> getChildren() {
        return this.muleRunners;
    }

    public void getExcluded() {
        try {
            URL[] urls = new URL[]{ClassUtils.getClassPathRoot((Class)this.getTestClass().getJavaClass())};
            URL fileUrl = new URLClassLoader(urls).getResource("mule-test-exclusions.txt");
            if (fileUrl != null) {
                URI fileUri = new URI(StringUtils.removeStart((String)fileUrl.toString(), (String)"jar:"));
                LineIterator lines = FileUtils.lineIterator((File)FileUtils.newFile((URI)fileUri));
                ArrayList<String> s = new ArrayList<String>();
                String line = null;
                while (lines.hasNext()) {
                    line = StringUtils.trimToEmpty((String)((String)lines.next()));
                    if (line.startsWith("#") || line == "" || line.length() <= 0) continue;
                    s.add(line);
                }
                excludedTests = s;
            }
        }
        catch (IOException ioex) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private List<Object[]> getParametersList(TestClass klass) throws Throwable {
        return (List)this.getParametersMethod(klass).invokeExplosively(null, new Object[0]);
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + testClass.getName());
    }
}

