/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import junit.framework.Assert;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.lifecycle.AlreadyInitialisedException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.AbstractMessageReceiver;

public class ConnectorLifecycleTestCase
extends AbstractMuleTestCase {
    private TestConnector connector;

    public void doSetUp() throws Exception {
        this.connector = new TestConnector();
        this.connector.setMuleContext(muleContext);
        this.connector.initialise();
    }

    public void doTearDown() throws Exception {
        this.connector = null;
    }

    public void testDoubleInitialiseConnector() throws Exception {
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        try {
            this.connector.initialise();
            Assert.fail((String)"Expected AlreadyInitialisedException not thrown.");
        }
        catch (AlreadyInitialisedException alreadyInitialisedException) {
            // empty catch block
        }
    }

    public void testDoubleStartConnector() throws Exception {
        System.out.println("Starting connector...");
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        System.out.println("Starting connector again...");
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
    }

    public void testDoubleStopConnector() throws Exception {
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnectorStartStop() throws Exception {
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.isStarted());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnectorStartOnly() throws Exception {
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnector() throws Exception {
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testReceiversLifecycle() throws Exception {
        this.connector.registerListener(ConnectorLifecycleTestCase.getTestService(), ConnectorLifecycleTestCase.getTestInboundEndpoint("in", "test://in"));
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isStarted());
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isStarted());
        this.connector.registerListener(ConnectorLifecycleTestCase.getTestService(), ConnectorLifecycleTestCase.getTestInboundEndpoint("in2", "test://in2"));
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isStarted());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isStarted());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in2")).isConnected());
        ConnectorLifecycleTestCase.assertFalse((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in2")).isStarted());
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.receivers.size());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in")).isStarted());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in2")).isConnected());
        ConnectorLifecycleTestCase.assertTrue((boolean)((AbstractMessageReceiver)this.connector.receivers.get((Object)"in2")).isStarted());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.receivers.size());
    }

    public void testDispatchersLifecycle() throws Exception {
        OutboundEndpoint out = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out", "test://out");
        this.connector.send(out, ConnectorLifecycleTestCase.getTestEvent("data"));
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConntected(out, false, true);
        this.connector.start();
        this.assertDispatcherStartedConntected(out, false, true);
        OutboundEndpoint out2 = ConnectorLifecycleTestCase.getTestOutboundEndpoint("out2", "test://out2");
        this.connector.send(out2, ConnectorLifecycleTestCase.getTestEvent("data"));
        ConnectorLifecycleTestCase.assertEquals((int)2, (int)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConntected(out, false, true);
        this.assertDispatcherStartedConntected(out2, false, true);
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
        this.connector.send(out, ConnectorLifecycleTestCase.getTestEvent("data"));
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.dispatchers.getNumIdle());
        this.assertDispatcherStartedConntected(out, false, true);
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)(this.connector.dispatchers.getNumActive() + this.connector.dispatchers.getNumIdle()));
    }

    public void testWorkManagerLifecycle() throws MuleException, WorkException {
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getReceiverWorkManager(null));
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getRequesterWorkManager());
        this.connector.start();
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getReceiverWorkManager(null));
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getRequesterWorkManager());
        this.connector.getReceiverWorkManager(null).doWork(this.createSomeWork());
        this.connector.getDispatcherWorkManager().doWork(this.createSomeWork());
        this.connector.getRequesterWorkManager().doWork(this.createSomeWork());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getReceiverWorkManager(null));
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getRequesterWorkManager());
        this.connector.start();
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getReceiverWorkManager(null));
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNotNull((Object)this.connector.getRequesterWorkManager());
        this.connector.getReceiverWorkManager(null).doWork(this.createSomeWork());
        this.connector.getDispatcherWorkManager().doWork(this.createSomeWork());
        this.connector.getRequesterWorkManager().doWork(this.createSomeWork());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getReceiverWorkManager(null));
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getDispatcherWorkManager());
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getRequesterWorkManager());
    }

    public void testSchedulerLifecycle() throws MuleException, WorkException {
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getScheduler());
        this.connector.start();
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isShutdown());
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isTerminated());
        this.connector.stop();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getScheduler());
        this.connector.start();
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isShutdown());
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.getScheduler().isTerminated());
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertNull((Object)this.connector.getScheduler());
    }

    protected Work createSomeWork() {
        return new Work(){

            public void run() {
                System.out.println("I'm doing some work");
            }

            public void release() {
            }
        };
    }

    private void assertDispatcherStartedConntected(OutboundEndpoint out, boolean started, boolean connected) throws Exception {
        AbstractMessageDispatcher dispatcher = (AbstractMessageDispatcher)this.connector.dispatchers.borrowObject((Object)out);
        ConnectorLifecycleTestCase.assertEquals((boolean)started, (boolean)dispatcher.isStarted());
        ConnectorLifecycleTestCase.assertEquals((boolean)connected, (boolean)dispatcher.isConnected());
        this.connector.dispatchers.returnObject((Object)out, (Object)dispatcher);
    }
}

