/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.util.FileUtils;
import org.mule.util.store.TextFileObjectStore;

public class TextFileStoreTestCase
extends AbstractMuleTestCase {
    public static final String DIR = ".mule/temp";
    TextFileObjectStore store;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FileUtils.deleteTree((File)new File(DIR));
    }

    protected void doTearDown() throws Exception {
        if (this.store != null) {
            this.store.dispose();
        }
        FileUtils.deleteTree((File)new File(DIR));
        super.doTearDown();
    }

    public void testTimedExpiry() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("1", (Object)"1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("2", (Object)"2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("3", (Object)"3"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("3"));
        Thread.sleep(4000L);
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("3"));
    }

    public void testTimedExpiryWithRestart() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("1", (Object)"1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("2", (Object)"2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("3", (Object)"3"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("3"));
        this.store.dispose();
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("3"));
        Thread.sleep(4000L);
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("3"));
        this.store.dispose();
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("3"));
    }

    public void testTimedExpiryWithObjects() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        try {
            TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("1", (Object)new Apple()));
            TextFileStoreTestCase.fail((String)"should not be abe to store objects");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMaxSize() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("bounded");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(-1);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("1", (Object)"1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("2", (Object)"2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("3", (Object)"3"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("3"));
        Thread.sleep(3000L);
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("3"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("4", (Object)"4"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("1"));
        this.store.expire();
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("1"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("3"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("4"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("5", (Object)"5"));
        this.store.expire();
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("2"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("3"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("4"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("5"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("6", (Object)"6"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("7", (Object)"7"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("8", (Object)"8"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.storeObject("9", (Object)"9"));
        this.store.expire();
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("7"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("8"));
        TextFileStoreTestCase.assertTrue((boolean)this.store.containsObject("9"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("3"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("4"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("5"));
        TextFileStoreTestCase.assertFalse((boolean)this.store.containsObject("6"));
    }
}

