/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.MessageAdapterSerialization;
import org.mule.transport.jms.JmsMessageUtils;

public class JmsMessageAdapter
extends AbstractMessageAdapter
implements MessageAdapterSerialization {
    private static final long serialVersionUID = -8151716840620558143L;
    private String jmsSpec;
    private Message jmsMessage;

    public JmsMessageAdapter(Object message) throws MuleException {
        this.setMessage(message);
    }

    protected JmsMessageAdapter(JmsMessageAdapter template) {
        super((MessageAdapter)template);
        this.jmsSpec = template.jmsSpec;
        this.jmsMessage = template.jmsMessage;
    }

    public void setSpecification(String newSpec) {
        if (!"1.1".equals(newSpec) && !"1.0.2b".equals(newSpec)) {
            throw new IllegalArgumentException("JMS specification needs to be one of the defined values in JmsConstants but was: " + newSpec);
        }
        this.jmsSpec = newSpec;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        return new String(this.getPayloadAsBytes(), encoding);
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return JmsMessageUtils.toByteArray(this.jmsMessage, this.jmsSpec, this.getEncoding());
    }

    public Object getPayload() {
        return this.jmsMessage;
    }

    private void setMessage(Object message) throws MuleException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (!(message instanceof Message)) {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        this.jmsMessage = (Message)message;
        try {
            String value = this.jmsMessage.getJMSCorrelationID();
            if (value != null) {
                props.put("JMSCorrelationID", value);
                props.put("MULE_CORRELATION_ID", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = this.jmsMessage.getJMSDeliveryMode();
            props.put("JMSDeliveryMode", new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Destination value = this.jmsMessage.getJMSDestination();
            if (value != null) {
                props.put("JMSDestination", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = this.jmsMessage.getJMSExpiration();
            props.put("JMSExpiration", new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = this.jmsMessage.getJMSMessageID();
            if (value != null) {
                props.put("JMSMessageID", value);
                props.put("MULE_MESSAGE_ID", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = this.jmsMessage.getJMSPriority();
            props.put("JMSPriority", new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            boolean value = this.jmsMessage.getJMSRedelivered();
            props.put("JMSRedelivered", value);
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Destination value = this.jmsMessage.getJMSReplyTo();
            if (value != null) {
                this.setReplyTo(value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = this.jmsMessage.getJMSTimestamp();
            props.put("JMSTimestamp", new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = this.jmsMessage.getJMSType();
            if (value != null) {
                props.put("JMSType", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Enumeration e = this.jmsMessage.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                try {
                    Object value = this.jmsMessage.getObjectProperty(key);
                    if (value == null) continue;
                    props.put(key, value);
                }
                catch (JMSException e1) {}
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.addInboundProperties(props);
    }

    public void setCorrelationId(String id) {
        super.setCorrelationId(id);
        this.setProperty("JMSCorrelationID", id);
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null && replyTo instanceof Destination) {
            this.setProperty("JMSReplyTo", replyTo, PropertyScope.INVOCATION);
        }
        super.setReplyTo(replyTo);
    }

    public ThreadSafeAccess newThreadCopy() {
        return new JmsMessageAdapter(this);
    }

    public byte[] getPayloadForSerialization() throws Exception {
        return JmsMessageUtils.toByteArray(this.jmsMessage, this.jmsSpec, this.getEncoding());
    }
}

