/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultMuleMessageDTO;
import org.mule.module.json.filters.IsJsonFilter;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxMessageAdapter
extends AbstractMessageAdapter {
    public static final String PAYLOAD_PARAM = "payload";
    public static final String REPLYTO_PARAM = "replyTo";
    protected transient IsJsonFilter filter = new IsJsonFilter();
    protected Object payload;

    public AjaxMessageAdapter(Object message) throws MuleException {
        this.init(message);
    }

    public AjaxMessageAdapter(Object message, MessageAdapter template) throws MuleException {
        super(template);
        this.init(message);
    }

    protected void init(Object message) throws MuleException {
        if (message instanceof Map) {
            Map map = (Map)message;
            Object p = map.remove(PAYLOAD_PARAM);
            if (p != null) {
                this.payload = this.filter.accept(p) ? this.readJsonAs(p, HashMap.class) : p;
            } else {
                throw new IllegalArgumentException("payload parameter not set");
            }
            this.setReplyTo(map.remove(REPLYTO_PARAM));
            if (map.size() > 0) {
                this.addProperties(map, PropertyScope.INVOCATION);
            }
        } else if (this.filter.accept(message)) {
            if (message.toString().indexOf(PAYLOAD_PARAM) > -1) {
                DefaultMuleMessageDTO dto = this.readJsonAs(message, DefaultMuleMessageDTO.class);
                this.payload = dto.getPayload();
                dto.addPropertiesTo(this);
            } else {
                this.payload = this.readJsonAs(message, HashMap.class);
            }
        } else {
            this.payload = message;
        }
    }

    protected <T> T readJsonAs(Object src, Class<T> type) throws DefaultMuleException {
        Object object;
        InputStream in = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            in = this.getObjectAsStream(src);
            object = mapper.readValue(in, type);
        }
        catch (IOException e) {
            try {
                throw new DefaultMuleException(CoreMessages.failedToReadPayload(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return (T)object;
    }

    protected InputStream getObjectAsStream(Object src) throws IOException {
        if (src instanceof InputStream) {
            return (InputStream)src;
        }
        if (src instanceof File) {
            return new FileInputStream((File)src);
        }
        if (src instanceof URL) {
            return ((URL)src).openStream();
        }
        if (src instanceof byte[]) {
            return new ByteArrayInputStream((byte[])src);
        }
        if (src instanceof String) {
            return new ByteArrayInputStream(((String)src).getBytes());
        }
        throw new IllegalArgumentException("OBject type not supported for JSON transform: " + src);
    }

    @Override
    public Object getPayload() {
        return this.payload;
    }
}

