/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import dojox.cometd.Channel;
import dojox.cometd.Client;
import java.util.List;
import org.mortbay.cometd.AbstractBayeux;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.ajax.container.AjaxServletConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxReplyToHandler
extends DefaultReplyToHandler {
    private AjaxServletConnector connector;

    public AjaxReplyToHandler(List<Transformer> transformers, AjaxServletConnector connector) {
        super(transformers, connector.getMuleContext());
        this.connector = connector;
    }

    @Override
    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        Object ret;
        AbstractBayeux bayeux = this.connector.getBayeux();
        Channel channel = bayeux.getChannel(replyTo.toString(), false);
        if (channel == null) {
            this.logger.warn((Object)("No ajax Channel: " + replyTo + ". Maybe the client unregistered interest."));
            return;
        }
        if (returnMessage.getExceptionPayload() != null) {
            ret = returnMessage.getExceptionPayload().getMessage();
        } else {
            returnMessage.applyTransformers(this.getTransformers());
            ret = returnMessage.getPayload();
        }
        for (Client client : channel.getSubscribers()) {
            channel.publish(client, ret, null);
        }
    }
}

