/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax.embedded;

import java.util.HashMap;
import javax.servlet.Servlet;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.ajax.AjaxMessageReceiver;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.i18n.AjaxMessages;

public class AjaxConnector
extends AjaxServletConnector {
    public static final String PROTOCOL = "ajax";
    private Server httpServer;
    private HashMap<String, BayeuxHolder> connectors = new HashMap();

    public AjaxConnector() {
        this.registerSupportedProtocol(PROTOCOL);
        this.setInitialStateStopped(false);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    protected void doInitialise() throws InitialisationException {
        this.httpServer = new Server();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBayeux getBayeux(ImmutableEndpoint endpoint) {
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getEndpointURI().getHost() + ":" + endpoint.getEndpointURI().getPort();
        HashMap<String, BayeuxHolder> hashMap = this.connectors;
        synchronized (hashMap) {
            BayeuxHolder connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null) {
                return connectorRef.servlet.getBayeux();
            }
        }
        throw new IllegalArgumentException("Endpoiont not registered: " + connectorKey);
    }

    protected void doDispose() {
        try {
            this.httpServer.stop();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error disposing Jetty server", (Throwable)e);
        }
        this.connectors.clear();
    }

    protected void doStart() throws MuleException {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart("Jetty Http Receiver"), e, (Object)this);
        }
    }

    protected void doStop() throws MuleException {
        try {
            for (BayeuxHolder connectorRef : this.connectors.values()) {
                connectorRef.connector.stop();
            }
            this.httpServer.stop();
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStop("Jetty Http Receiver"), e, (Object)this);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    public MessageReceiver registerListener(Service service, InboundEndpoint endpoint) throws Exception {
        MessageReceiver receiver = super.registerListener(service, endpoint);
        BayeuxHolder holder = this.registerBayeuxEndpoint(receiver.getEndpoint());
        ((AjaxMessageReceiver)receiver).setBayeux(holder.getBayeux());
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BayeuxHolder registerBayeuxEndpoint(ImmutableEndpoint endpoint) throws MuleException {
        BayeuxHolder holder;
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getEndpointURI().getHost() + ":" + endpoint.getEndpointURI().getPort();
        HashMap<String, BayeuxHolder> hashMap = this.connectors;
        synchronized (hashMap) {
            holder = this.connectors.get(connectorKey);
            if (holder == null) {
                AbstractConnector connector = this.createJettyConnector();
                connector.setPort(endpoint.getEndpointURI().getPort());
                connector.setHost(endpoint.getEndpointURI().getHost());
                if ("localhost".equalsIgnoreCase(endpoint.getEndpointURI().getHost())) {
                    this.logger.warn((Object)"You use localhost interface! It means that no external connections will be available. Don't you want to use 0.0.0.0 instead (all network interfaces)?");
                }
                this.getHttpServer().addConnector((Connector)connector);
                ContinuationCometdServlet servlet = this.createServletForConnector((Connector)connector, endpoint);
                holder = new BayeuxHolder((Connector)connector, servlet);
                if (this.getBayeux() == null) {
                    this.setBayeux(servlet.getBayeux());
                }
                this.connectors.put(connectorKey, holder);
            } else {
                holder.increment();
            }
            AbstractBayeux bayeux = holder.servlet.getBayeux();
            bayeux.setJSONCommented(this.isJsonCommented());
        }
        return holder;
    }

    public void destroyReceiver(MessageReceiver receiver, ImmutableEndpoint endpoint) throws Exception {
        this.unregisterConnectorListener(receiver);
        super.destroyReceiver(receiver, endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterConnectorListener(MessageReceiver receiver) throws Exception {
        InboundEndpoint endpoint = receiver.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getEndpointURI().getHost() + ":" + endpoint.getEndpointURI().getPort();
        HashMap<String, BayeuxHolder> hashMap = this.connectors;
        synchronized (hashMap) {
            BayeuxHolder connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null && connectorRef.decrement() == 0) {
                this.getHttpServer().removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                this.connectors.remove(connectorKey);
            }
        }
    }

    public void setDispatcherFactory(MessageDispatcherFactory dispatcherFactory) {
        super.setDispatcherFactory(dispatcherFactory);
    }

    protected AbstractConnector createJettyConnector() {
        return new SelectChannelConnector();
    }

    public Server getHttpServer() {
        return this.httpServer;
    }

    protected ContinuationCometdServlet createServletForConnector(Connector connector, ImmutableEndpoint endpoint) throws MuleException {
        ContinuationCometdServlet servlet = new ContinuationCometdServlet();
        Context context = new Context((HandlerContainer)this.getHttpServer(), "/", 0);
        context.setConnectorNames(new String[]{connector.getName()});
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)servlet);
        context.setResourceBase(endpoint.getEndpointURI().getPath());
        context.addServlet(holder, "/ajax/*");
        context.addServlet("org.mortbay.jetty.servlet.DefaultServlet", "/");
        try {
            connector.start();
            context.start();
        }
        catch (Exception e) {
            throw new InitialisationException(AjaxMessages.failedToStartAjaxServlet(), (Throwable)e, (Initialisable)((Object)this));
        }
        if (this.getInterval() != -1) {
            holder.setInitParameter("interval", Integer.toString(this.getInterval()));
        }
        holder.setInitParameter("JSONCommented", Boolean.toString(this.isJsonCommented()));
        if (this.getLogLevel() != -1) {
            holder.setInitParameter("logLevel", Integer.toString(this.getLogLevel()));
        }
        if (this.getMaxInterval() != -1) {
            holder.setInitParameter("maxInterval", Integer.toString(this.getMaxInterval()));
        }
        if (this.getMultiFrameInterval() != -1) {
            holder.setInitParameter("multiFrameInterval", Integer.toString(this.getMultiFrameInterval()));
        }
        if (this.getTimeout() != -1) {
            holder.setInitParameter("timeout", Integer.toString(this.getTimeout()));
        }
        if (this.getRefsThreshold() != -1) {
            holder.setInitParameter("refsThreshold", Integer.toString(this.getRefsThreshold()));
        }
        holder.setInitParameter("requestAvailable", Boolean.toString(this.isRequestAvailable()));
        holder.setInitParameter("directDeliver", Boolean.toString(this.isDirectDeliver()));
        return servlet;
    }

    public class BayeuxHolder {
        Connector connector;
        ContinuationCometdServlet servlet;
        int refCount;

        public BayeuxHolder(Connector connector, ContinuationCometdServlet servlet) {
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public AbstractBayeux getBayeux() {
            return this.servlet.getBayeux();
        }
    }
}

