/*
 * $Id: Dom4jXPathExpressionWithNamespaceTestCase.java 13194 2008-11-02 21:10:49Z rossmason $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.xml.functional;

import java.text.MessageFormat;
import java.util.Properties;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;

public class Dom4jXPathExpressionWithNamespaceTestCase extends AbstractXmlPropertyExtractorTestCase
{

    public static final String MESSAGE = "<foo:endpoint xmlns:foo=\"http://foo.com\">{0}</foo:endpoint>";

    public Dom4jXPathExpressionWithNamespaceTestCase()
    {
        super(true);
    }

    protected Properties getStartUpProperties()
    {
        Properties p = new Properties();
        p.setProperty("selector.expression", "/foo:endpoint");
        p.setProperty("selector.evaluator", "xpath");

        return p;
    }

    protected Object getMatchMessage() throws Exception
    {
        return documentFor("matchingEndpoint1");
    }

    protected Object getErrorMessage() throws Exception
    {
        return documentFor("missingEndpoint");
    }

    protected Document documentFor(String name) throws Exception
    {
        return DocumentHelper.parseText(MessageFormat.format(MESSAGE, name));

    }

}