/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PGPPacket {
    private int packetid = 256;

    public abstract void decodeBody(PGPPacketDataInputStream var1, PGPAlgorithmFactory var2) throws IOException, PGPFatalDataFormatException, PGPDataFormatException;

    public void encode(OutputStream out) throws IOException {
        PGPPacketDataOutputStream pout = new PGPPacketDataOutputStream(out, this.getPacketID(), this.getForceLengthType());
        this.encodeBody(pout);
        pout.close();
    }

    public abstract void encodeBody(PGPPacketDataOutputStream var1) throws IOException;

    public abstract boolean equals(Object var1);

    public int getForceLengthType() {
        return -1;
    }

    public byte getPacketID() {
        return (byte)this.packetid;
    }

    public int hashCode() {
        return this.getPacketID();
    }

    public boolean isLazy() {
        return false;
    }

    public void setPacketID(byte id) {
        this.packetid = id;
    }
}

