/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.bpm;

import java.util.Map;
import javax.resource.spi.work.Work;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.bpm.ProcessConnector;

public class ProcessMessageReceiver
extends AbstractMessageReceiver {
    private ProcessConnector connector = null;

    public ProcessMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        this.connector = (ProcessConnector)connector;
    }

    public MuleMessage generateSynchronousEvent(String endpoint, Object payload, Map messageProperties) throws MuleException {
        this.logger.debug((Object)("Executing process is sending an event (synchronously) to Mule endpoint = " + endpoint));
        MuleMessage response = this.generateEvent(endpoint, payload, messageProperties, true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Synchronous response is " + (response != null ? response.getPayload() : null)));
        }
        return response;
    }

    public void generateAsynchronousEvent(String endpoint, Object payload, Map messageProperties) throws MuleException {
        this.logger.debug((Object)("Executing process is dispatching an event (asynchronously) to Mule endpoint = " + endpoint));
        try {
            WorkManager workManager = this.getWorkManager();
            if (workManager == null) {
                throw new ConnectorException(MessageFactory.createStaticMessage((String)"WorkManager not available"), this.getConnector());
            }
            workManager.scheduleWork((Work)new Worker(endpoint, payload, messageProperties));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected MuleMessage generateEvent(String endpoint, Object payload, Map messageProperties, boolean synchronous) throws MuleException {
        Object message = payload instanceof MuleMessage ? (MuleMessage)payload : new DefaultMuleMessage((Object)this.connector.getMessageAdapter(payload), this.connector.getMuleContext());
        message.addProperties(messageProperties);
        if (this.connector.isAllowGlobalDispatcher()) {
            if (synchronous) {
                return this.connector.getMuleClient().send(endpoint, (MuleMessage)message);
            }
            this.connector.getMuleClient().dispatch(endpoint, (MuleMessage)message);
            return null;
        }
        message.setStringProperty("MULE_BPM_ENDPOINT", endpoint);
        return this.routeMessage((MuleMessage)message, synchronous);
    }

    private class Worker
    implements Work {
        private String endpoint;
        private Object payload;
        private Map messageProperties;

        public Worker(String endpoint, Object payload, Map messageProperties) {
            this.endpoint = endpoint;
            this.payload = payload;
            this.messageProperties = messageProperties;
        }

        public void run() {
            try {
                ProcessMessageReceiver.this.generateEvent(this.endpoint, this.payload, this.messageProperties, false);
            }
            catch (Exception e) {
                ProcessMessageReceiver.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

