/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.InputStream;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.file.ReceiverFileInputStream;

public class FileMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 4127485947547548996L;
    protected File file = null;
    protected InputStream fileInputStream;

    public FileMessageAdapter(Object message) throws MuleException {
        if (message instanceof File) {
            this.setFileMessage((File)message);
        } else if (message instanceof ReceiverFileInputStream) {
            this.setStreamMessage((ReceiverFileInputStream)message);
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
    }

    protected FileMessageAdapter(FileMessageAdapter template) {
        super(template);
        this.file = template.file;
        this.fileInputStream = template.fileInputStream;
    }

    public Object getPayload() {
        if (this.fileInputStream != null) {
            return this.fileInputStream;
        }
        return this.file;
    }

    protected void setFileMessage(File message) throws MessagingException {
        this.file = message;
        this.setProperty("originalFilename", this.file.getName());
        this.setProperty("directory", this.file.getParent());
    }

    protected void setStreamMessage(ReceiverFileInputStream message) throws MessagingException {
        this.file = message.getCurrentFile();
        this.fileInputStream = message;
        this.setProperty("originalFilename", this.file.getName());
        this.setProperty("directory", this.file.getParent());
    }

    public String getUniqueId() {
        return this.file.getAbsolutePath();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new FileMessageAdapter(this);
    }
}

