/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import cryptix.jce.examples.FileHashing;
import cryptix.jce.examples.SymmetricCipher;
import cryptix.jce.provider.CryptixCrypto;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Security;

public final class RunSamples {
    private static boolean addProviderCryptix() {
        CryptixCrypto cryptix_provider = new CryptixCrypto();
        int result = Security.addProvider(cryptix_provider);
        if (result == -1) {
            System.out.println("Provider entry already in file.\n");
            return false;
        }
        System.out.println("Provider added at position: " + result);
        return true;
    }

    public static void main(String[] args) {
        FileInputStream fis = null;
        String filename = null;
        if (args.length < 1) {
            System.out.println("You did not specify a file to encrypt!?");
            System.out.println("If you want one to encrypt just place a filename as first argument to the program.");
        } else {
            try {
                fis = new FileInputStream(args[0]);
                fis.close();
                filename = args[0];
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Filename is not valid!");
                fnfe.printStackTrace();
                System.exit(-1);
            }
            catch (IOException ioe) {
                System.out.println("IO Error!");
                ioe.printStackTrace();
                System.exit(-1);
            }
        }
        if (!RunSamples.addProviderCryptix()) {
            System.out.println("Could not add provider cryptix.\n");
            System.exit(-1);
        }
        String provider = "CryptixCrypto";
        String[] secret_algorithm = new String[]{};
        String[] mode = new String[]{"ECB", "CBC", "OFB"};
        String[] padding = new String[]{"None", "NoPadding", "PKCS#5"};
        int i = 0;
        int j = 0;
        int k = 0;
        i = 0;
        while (i < secret_algorithm.length) {
            j = 0;
            while (j < mode.length) {
                k = 0;
                while (k < padding.length) {
                    System.out.println("***************\nNew cipher object!");
                    System.out.println("Using:" + secret_algorithm[i] + "/" + mode[j] + "/" + padding[k] + "\n");
                    SymmetricCipher symmetricCipher = new SymmetricCipher();
                    symmetricCipher.run(secret_algorithm[i], mode[j], padding[k], provider, filename);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("**************\nRunning hash functions:");
        String[] hashfunctions = new String[]{"MD2", "MD4", "MD5", "RIPEMD128", "RIPEMD160", "SHA", "SHA0", "SHA1"};
        if (filename != null) {
            int ii = 0;
            while (ii < hashfunctions.length) {
                System.out.println("***************");
                System.out.println("New hash object.");
                System.out.println("Using: " + hashfunctions[ii] + "/" + provider);
                FileHashing fh = new FileHashing();
                fh.run(hashfunctions[ii], provider, filename);
                ++ii;
            }
        } else {
            System.out.println("You did not provide any file to hash.");
        }
        System.out.println("**************");
        System.out.println();
    }
}

