/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.handlers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.config.spring.factories.InboundEndpointFactoryBean;
import org.mule.config.spring.factories.OutboundEndpointFactoryBean;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.MuleDefinitionParserConfiguration;
import org.mule.config.spring.parsers.PostProcessor;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.ValueMap;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportEndpointDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportGlobalEndpointDefinitionParser;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractMuleNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String GLOBAL_ENDPOINT = "endpoint";
    public static final String INBOUND_ENDPOINT = "inbound-endpoint";
    public static final String OUTBOUND_ENDPOINT = "outbound-endpoint";

    protected final void registerIgnoredElement(String name) {
        this.registerBeanDefinitionParser(name, new IgnoredDefinitionParser());
    }

    protected MuleDefinitionParserConfiguration registerConnectorDefinitionParser(Class connectorClass) {
        return this.registerConnectorDefinitionParser(new MuleOrphanDefinitionParser(connectorClass, true));
    }

    protected MuleDefinitionParserConfiguration registerConnectorDefinitionParser(MuleDefinitionParser parser) {
        this.registerBeanDefinitionParser("connector", parser);
        return parser;
    }

    protected MuleDefinitionParserConfiguration registerMuleBeanDefinitionParser(String name, MuleDefinitionParser parser) {
        this.registerBeanDefinitionParser(name, parser);
        return parser;
    }

    protected MuleDefinitionParserConfiguration registerStandardTransportEndpoints(String protocol, String[] requiredAttributes) {
        return new RegisteredMdps(protocol, false, requiredAttributes);
    }

    protected MuleDefinitionParserConfiguration registerMetaTransportEndpoints(String protocol) {
        return new RegisteredMdps(protocol, true, new String[0]);
    }

    protected Class getInboundEndpointFactoryBeanClass() {
        return InboundEndpointFactoryBean.class;
    }

    protected Class getOutboundEndpointFactoryBeanClass() {
        return OutboundEndpointFactoryBean.class;
    }

    protected Class getGlobalEndpointBuilderBeanClass() {
        return EndpointURIEndpointBuilder.class;
    }

    private class RegisteredMdps
    implements MuleDefinitionParserConfiguration {
        private Set bdps = new HashSet();

        private RegisteredMdps(String protocol, boolean isMeta, String[] requiredAttributes) {
            AbstractMuleNamespaceHandler.this.registerBeanDefinitionParser(AbstractMuleNamespaceHandler.GLOBAL_ENDPOINT, this.add(new TransportGlobalEndpointDefinitionParser(protocol, isMeta, AbstractMuleNamespaceHandler.this.getGlobalEndpointBuilderBeanClass(), requiredAttributes, new String[0])));
            AbstractMuleNamespaceHandler.this.registerBeanDefinitionParser(AbstractMuleNamespaceHandler.INBOUND_ENDPOINT, this.add(new TransportEndpointDefinitionParser(protocol, isMeta, AbstractMuleNamespaceHandler.this.getInboundEndpointFactoryBeanClass(), requiredAttributes, new String[0])));
            AbstractMuleNamespaceHandler.this.registerBeanDefinitionParser(AbstractMuleNamespaceHandler.OUTBOUND_ENDPOINT, this.add(new TransportEndpointDefinitionParser(protocol, isMeta, AbstractMuleNamespaceHandler.this.getOutboundEndpointFactoryBeanClass(), requiredAttributes, new String[0])));
        }

        private MuleDefinitionParser add(MuleDefinitionParser bdp) {
            this.bdps.add(bdp);
            return bdp;
        }

        public MuleDefinitionParserConfiguration registerPreProcessor(PreProcessor preProcessor) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).registerPreProcessor(preProcessor);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration registerPostProcessor(PostProcessor postProcessor) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).registerPostProcessor(postProcessor);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addReference(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addReference(propertyName);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addMapping(String propertyName, Map mappings) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addMapping(propertyName, mappings);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addMapping(String propertyName, String mappings) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addMapping(propertyName, mappings);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addMapping(String propertyName, ValueMap mappings) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addMapping(propertyName, mappings);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addAlias(String alias, String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addAlias(alias, propertyName);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addCollection(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addCollection(propertyName);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addIgnored(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addIgnored(propertyName);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration removeIgnored(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).removeIgnored(propertyName);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration setIgnoredDefault(boolean ignoreAll) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).setIgnoredDefault(ignoreAll);
            }
            return this;
        }

        public MuleDefinitionParserConfiguration addBeanFlag(String flag) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addBeanFlag(flag);
            }
            return this;
        }
    }

    private class IgnoredDefinitionParser
    implements BeanDefinitionParser {
        private IgnoredDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            return null;
        }
    }
}

