/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ClassOrRefDefinitionParser
extends AbstractBeanDefinitionParser {
    private String propertyName;

    public ClassOrRefDefinitionParser(String propertyName) {
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new IllegalArgumentException("propertyName cannot be null");
        }
        this.propertyName = propertyName;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        MutablePropertyValues parentProps = parserContext.getContainingBeanDefinition().getPropertyValues();
        String ref = element.getAttribute("ref");
        String className = element.getAttribute("class");
        if (StringUtils.isBlank((String)ref) && StringUtils.isBlank((String)className)) {
            String elementName = element.getLocalName();
            throw new IllegalArgumentException("Neither ref nor class attribute specified for the " + elementName + " element");
        }
        if (StringUtils.isNotBlank((String)ref)) {
            parentProps.addPropertyValue(this.propertyName, (Object)new RuntimeBeanReference(ref));
        } else {
            Object instance;
            try {
                instance = ClassUtils.instanciateClass(className, ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            parentProps.addPropertyValue(this.propertyName, instance);
        }
        return null;
    }
}

