/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.processors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class CheckRequiredAttributes
implements PreProcessor {
    private Map<String, Integer> knownAttributes = new HashMap<String, Integer>();
    private Map<Integer, Integer> numberOfAttributes = new HashMap<Integer, Integer>();
    private String summary;

    public CheckRequiredAttributes(String[][] attributeSets) {
        StringBuffer buffer = new StringBuffer();
        for (int set = 0; set < attributeSets.length; ++set) {
            String[] attributes = attributeSets[set];
            if (attributes.length <= 0) continue;
            Integer index = new Integer(set);
            this.numberOfAttributes.put(index, new Integer(attributes.length));
            if (set > 0) {
                buffer.append("; ");
            }
            for (int attribute = 0; attribute < attributes.length; ++attribute) {
                this.knownAttributes.put(attributes[attribute], index);
                if (attribute > 0) {
                    buffer.append(", ");
                }
                buffer.append(attributes[attribute]);
            }
        }
        this.summary = buffer.toString();
    }

    public void preProcess(PropertyConfiguration config, Element element) {
        Integer index;
        HashMap<Integer, Integer> foundAttributesCount = new HashMap<Integer, Integer>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String alias = SpringXMLUtils.attributeName((Attr)attributes.item(i));
            if (!this.knownAttributes.containsKey(alias)) continue;
            index = this.knownAttributes.get(alias);
            if (!foundAttributesCount.containsKey(index)) {
                foundAttributesCount.put(index, new Integer(0));
            }
            foundAttributesCount.put(index, new Integer(1 + (Integer)foundAttributesCount.get(index)));
        }
        boolean ok = this.knownAttributes.size() == 0;
        Iterator indices = foundAttributesCount.keySet().iterator();
        while (indices.hasNext() && !ok) {
            index = (Integer)indices.next();
            Integer count = (Integer)foundAttributesCount.get(index);
            ok = this.numberOfAttributes.get(index).equals(count);
        }
        if (!ok) {
            throw new CheckRequiredAttributesException(element, this.summary);
        }
    }

    public static class CheckRequiredAttributesException
    extends IllegalStateException {
        private CheckRequiredAttributesException(Element element, String summary) {
            super("Element " + SpringXMLUtils.elementToString(element) + " must have all attributes for one of the sets: " + summary + ".");
        }
    }
}

