/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import net.sf.retrotranslator.runtime.java.lang._Integer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScriptContext
implements ScriptContext {
    protected Writer writer;
    protected Writer errorWriter;
    protected Reader reader;
    protected Bindings engineScope = new SimpleBindings();
    protected Bindings globalScope = null;
    private static List<Integer> scopes = new ArrayList<Integer>(2);

    public SimpleScriptContext() {
        this.reader = new InputStreamReader(System.in);
        this.writer = new PrintWriter(System.out, true);
        this.errorWriter = new PrintWriter(System.err, true);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        switch (scope) {
            case 100: {
                if (bindings == null) {
                    throw new NullPointerException("Engine scope cannot be null.");
                }
                this.engineScope = bindings;
                break;
            }
            case 200: {
                this.globalScope = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope value.");
            }
        }
    }

    @Override
    public Object getAttribute(String name) {
        if (this.engineScope.containsKey(name)) {
            return this.getAttribute(name, 100);
        }
        if (this.globalScope != null && this.globalScope.containsKey(name)) {
            return this.getAttribute(name, 200);
        }
        return null;
    }

    @Override
    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 100: {
                return this.engineScope.get(name);
            }
            case 200: {
                if (this.globalScope != null) {
                    return this.globalScope.get(name);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        switch (scope) {
            case 100: {
                if (this.getBindings(100) != null) {
                    return this.getBindings(100).remove(name);
                }
                return null;
            }
            case 200: {
                if (this.getBindings(200) != null) {
                    return this.getBindings(200).remove(name);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        switch (scope) {
            case 100: {
                this.engineScope.put(name, value);
                return;
            }
            case 200: {
                if (this.globalScope != null) {
                    this.globalScope.put(name, value);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.engineScope.containsKey(name)) {
            return 100;
        }
        if (this.globalScope != null && this.globalScope.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Bindings getBindings(int scope) {
        if (scope == 100) {
            return this.engineScope;
        }
        if (scope == 200) {
            return this.globalScope;
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public List<Integer> getScopes() {
        return scopes;
    }

    static {
        scopes.add(_Integer.valueOf((int)100));
        scopes.add(_Integer.valueOf((int)200));
        scopes = Collections.unmodifiableList(scopes);
    }
}

