/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.Iterator;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.MessageAdapterSerialization;
import org.mule.util.StringUtils;

public class XmppMessageAdapter
extends AbstractMessageAdapter
implements MessageAdapterSerialization {
    public static final String DEFAULT_SUBJECT = "(no subject)";
    public static final String DEFAULT_THREAD = "(no thread)";
    private static final long serialVersionUID = -4003299444661664762L;
    private final Packet message;

    public XmppMessageAdapter(Object message) throws MuleException {
        if (message instanceof Packet) {
            this.message = (Packet)message;
            Iterator iter = this.message.getPropertyNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                this.setProperty(name, this.message.getProperty(name));
            }
            if (this.message instanceof Message) {
                Message msg = (Message)this.message;
                this.setProperty("subject", StringUtils.defaultIfEmpty((String)msg.getSubject(), (String)DEFAULT_SUBJECT));
                this.setProperty("thread", StringUtils.defaultIfEmpty((String)msg.getThread(), (String)DEFAULT_THREAD));
            }
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
    }

    protected XmppMessageAdapter(XmppMessageAdapter template) {
        super(template);
        this.message = template.message;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        if (this.message instanceof Message) {
            return ((Message)this.message).getBody();
        }
        return this.message.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.message instanceof Message) {
            return ((Message)this.message).getBody().getBytes();
        }
        return this.message.toString().getBytes();
    }

    public Object getPayload() {
        return this.message;
    }

    public String getUniqueId() {
        return this.message.getPacketID();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new XmppMessageAdapter(this);
    }

    public byte[] getPayloadForSerialization() throws Exception {
        return this.getPayloadAsBytes();
    }
}

