/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -4238448252206941125L;
    private PayloadHolder payloadHolder;
    private String contentType;
    private String characterEncoding;
    private final Map<String, String> requestParameters;

    public HttpRequestMessageAdapter(Object message) throws MuleException {
        HashMap<String, Object> headers;
        if (message instanceof HttpServletRequest) {
            String key;
            Object value;
            HttpServletRequest request = (HttpServletRequest)message;
            Enumeration paramNames = request.getParameterNames();
            this.requestParameters = new HashMap<String, String>();
            if (paramNames != null) {
                while (paramNames.hasMoreElements()) {
                    String paramName = (String)paramNames.nextElement();
                    this.requestParameters.put(paramName, request.getParameterValues(paramName)[0]);
                }
            }
            this.setPayload(request);
            this.setContentEncoding((HttpServletRequest)message);
            this.setupUniqueId(request);
            this.contentType = request.getContentType();
            this.characterEncoding = request.getCharacterEncoding();
            headers = new HashMap<String, Object>();
            Map parameterMap = request.getParameterMap();
            if (parameterMap != null && parameterMap.size() > 0) {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    String key2 = (String)entry.getKey();
                    value = entry.getValue();
                    if (value == null) continue;
                    if (value.getClass().isArray() && ((Object[])value).length == 1) {
                        headers.put(key2, ((Object[])value)[0]);
                        continue;
                    }
                    headers.put(key2, value);
                }
            }
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                headers.put(key, request.getAttribute(key));
            }
            Enumeration e2 = request.getHeaderNames();
            while (e2.hasMoreElements()) {
                String realKey = key = (String)e2.nextElement();
                if (key.startsWith("X-MULE_")) {
                    realKey = key.substring(2);
                }
                value = request.getHeader(key);
                if ("Host".equalsIgnoreCase(key)) {
                    realKey = "Host";
                    int port = request.getLocalPort();
                    if (!((String)value).contains(":") && port != 80 && port != 443) {
                        value = (String)value + ":" + port;
                    }
                }
                headers.put(realKey, value);
            }
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
        this.addInboundProperties(headers);
    }

    protected HttpRequestMessageAdapter(HttpRequestMessageAdapter template) {
        super(template);
        this.payloadHolder = template.payloadHolder;
        this.contentType = template.contentType;
        this.characterEncoding = template.characterEncoding;
        this.requestParameters = template.requestParameters;
    }

    protected void setContentEncoding(HttpServletRequest request) {
        int i;
        String contentType = request.getContentType();
        if (contentType != null && (i = contentType.indexOf("charset")) > -1) {
            int x = contentType.lastIndexOf(";");
            if (x > i) {
                this.setEncoding(contentType.substring(i + 8, x));
            } else {
                this.setEncoding(contentType.substring(i + 8));
            }
        }
    }

    private void setPayload(HttpServletRequest request) throws MessagingException {
        this.payloadHolder = "GET".equalsIgnoreCase(request.getMethod()) ? new GetPayloadHolder(request) : new PostPayloadHolder(request);
    }

    @Override
    public Object getPayload() {
        return this.payloadHolder.getPayload();
    }

    private void setupUniqueId(HttpServletRequest request) {
        HttpSession session = null;
        try {
            session = request.getSession(false);
            this.id = session.getId();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setReplyTo(Object replyTo) {
        if (replyTo != null && replyTo.toString().startsWith("http")) {
            this.setProperty("Location", replyTo);
        } else {
            this.removeProperty("Location");
        }
        super.setReplyTo(replyTo);
    }

    @Override
    public Object getReplyTo() {
        Object replyto = this.getProperty("MULE_REPLYTO");
        if (replyto == null) {
            replyto = this.getProperty("Location");
        }
        return replyto;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Enumeration<String> getParameterNames() {
        throw new UnsupportedOperationException("getParameterNames");
    }

    public String[] getParameterValues(String paramName) {
        throw new UnsupportedOperationException("getParameterValues");
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        return new HttpRequestMessageAdapter(this);
    }

    private static class PostPayloadHolder
    implements PayloadHolder {
        private transient InputStream payload;

        public PostPayloadHolder(HttpServletRequest request) {
            try {
                this.payload = request.getInputStream();
            }
            catch (IOException iox) {
                throw new RuntimeException(iox);
            }
        }

        public Object getPayload() {
            return this.payload;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            byte[] payloadBytes = IOUtils.toByteArray((InputStream)this.payload);
            out.writeInt(payloadBytes.length);
            out.write(payloadBytes);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int payloadSize = in.readInt();
            byte[] payloadBytes = new byte[payloadSize];
            in.read(payloadBytes);
            this.payload = new ByteArrayInputStream(payloadBytes);
        }
    }

    private static class GetPayloadHolder
    implements PayloadHolder {
        private String payload;

        public GetPayloadHolder(HttpServletRequest request) {
            this.payload = request.getRequestURI().toString() + "?" + request.getQueryString();
        }

        public Object getPayload() {
            return this.payload;
        }
    }

    private static interface PayloadHolder
    extends Serializable {
        public Object getPayload();
    }
}

