/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.transformers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transport.servlet.HttpRequestMessageAdapter;
import org.mule.util.SystemUtils;

public class HttpRequestToParameter
extends AbstractMessageAwareTransformer {
    public HttpRequestToParameter() {
        this.registerSourceType(Object.class);
        this.setReturnClass(String.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        String payloadParam;
        HttpRequestMessageAdapter messageAdapter = (HttpRequestMessageAdapter)message.getAdapter();
        String payload = messageAdapter.getStringProperty(payloadParam = messageAdapter.getStringProperty("org.mule.servlet.payload.param", "payload"), null);
        if (payload == null) {
            if (messageAdapter.getContentType() == null || messageAdapter.getContentType().startsWith("text/")) {
                try {
                    InputStream is = (InputStream)message.getPayload();
                    BufferedReader reader = messageAdapter.getCharacterEncoding() != null ? new BufferedReader(new InputStreamReader(is, messageAdapter.getCharacterEncoding())) : new BufferedReader(new InputStreamReader(is));
                    StringBuffer buffer = new StringBuffer(8192);
                    String line = reader.readLine();
                    while (line != null) {
                        buffer.append(line);
                        line = reader.readLine();
                        if (line == null) continue;
                        buffer.append(SystemUtils.LINE_SEPARATOR);
                    }
                    payload = buffer.toString();
                }
                catch (IOException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            }
            if (messageAdapter.getContentType().equals("application/x-www-form-urlencoded")) {
                InputStream is = (InputStream)message.getPayload();
                Properties props = new Properties();
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        throw new TransformerException(this, (Throwable)e2);
                    }
                }
                return props.get(payloadParam);
            }
        }
        return payload;
    }
}

