/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.mule.transport.cxf.support.DelegatingOutputStream;
import org.mule.transport.cxf.transport.MuleUniversalTransport;

public class MuleUniversalDestination
extends AbstractDestination {
    public static final String RESPONSE_OBSERVER = "mule.destination.response.observer";
    private static final Logger LOGGER = Logger.getLogger(MuleUniversalDestination.class.getName());
    private MuleUniversalTransport transport;

    public MuleUniversalDestination(MuleUniversalTransport transport, EndpointReferenceType ref, EndpointInfo ei) {
        super(ref, ei);
        this.transport = transport;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new ResponseConduit(null);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void shutdown() {
        this.transport.remove(this);
        super.shutdown();
    }

    protected boolean markPartialResponse(Message partialResponse, EndpointReferenceType decoupledTarget) {
        partialResponse.put((Object)Message.RESPONSE_CODE, (Object)202);
        partialResponse.getExchange().put(EndpointReferenceType.class, (Object)decoupledTarget);
        return true;
    }

    protected ConduitInitiator getConduitInitiator() {
        return this.transport;
    }

    public class ResponseConduit
    extends AbstractConduit {
        public ResponseConduit(EndpointReferenceType arg0) {
            super(arg0);
        }

        public void prepare(Message message) throws IOException {
            DelegatingOutputStream stream = new DelegatingOutputStream(new ByteArrayOutputStream());
            message.setContent(OutputStream.class, (Object)stream);
            message.setContent(DelegatingOutputStream.class, (Object)stream);
        }

        public void close(Message message) throws IOException {
            ((OutputStream)message.getContent(OutputStream.class)).close();
        }

        protected Logger getLogger() {
            return LOGGER;
        }
    }
}

