/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.guice;

import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.registry.AbstractRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceRegistry
extends AbstractRegistry {
    private Injector injector = null;

    public GuiceRegistry() {
        super("guice");
    }

    GuiceRegistry(Injector injector) {
        this();
        this.injector = injector;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
    }

    @Override
    protected void doDispose() {
    }

    @Override
    public Object lookupObject(String key) {
        return null;
    }

    @Override
    public <T> Collection lookupObjects(Class<T> type) {
        try {
            List bindings = this.injector.findBindingsByType(TypeLiteral.get(type));
            if (bindings != null && bindings.size() > 0) {
                ArrayList<Object> list = new ArrayList<Object>(bindings.size());
                for (Binding binding : bindings) {
                    list.add(binding.getProvider().get());
                }
                return list;
            }
            return Collections.EMPTY_LIST;
        }
        catch (ConfigurationException e) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        throw new UnsupportedOperationException("registerObject");
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("registerObject");
    }

    public void registerObjects(Map objects) throws RegistrationException {
        throw new UnsupportedOperationException("registerObjects");
    }

    @Override
    public void unregisterObject(String key) throws RegistrationException {
        throw new UnsupportedOperationException("unregisterObject");
    }

    @Override
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("unregisterObject");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

