/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.component.LifecycleAdapterFactory;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.object.ObjectFactory;
import org.mule.api.routing.BindingCollection;
import org.mule.api.service.ServiceAware;
import org.mule.component.AbstractComponent;
import org.mule.component.NullLifecycleAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.routing.binding.DefaultBindingCollection;

public abstract class AbstractJavaComponent
extends AbstractComponent
implements JavaComponent {
    protected EntryPointResolverSet entryPointResolverSet;
    protected BindingCollection bindingCollection = new DefaultBindingCollection();
    protected ObjectFactory objectFactory;
    protected LifecycleAdapterFactory lifecycleAdapterFactory;
    private AtomicBoolean wireObject = new AtomicBoolean(true);

    public AbstractJavaComponent() {
    }

    public AbstractJavaComponent(ObjectFactory objectFactory) {
        this(objectFactory, null, null);
    }

    public AbstractJavaComponent(ObjectFactory objectFactory, EntryPointResolverSet entryPointResolverSet, BindingCollection bindingCollection) {
        this.objectFactory = objectFactory;
        this.entryPointResolverSet = entryPointResolverSet;
        if (bindingCollection != null) {
            this.bindingCollection = bindingCollection;
        }
    }

    protected Object doInvoke(MuleEvent event) throws Exception {
        return this.invokeComponentInstance(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeComponentInstance(MuleEvent event) throws Exception {
        Object object;
        LifecycleAdapter componentLifecycleAdapter = null;
        try {
            componentLifecycleAdapter = this.borrowComponentLifecycleAdaptor();
            object = componentLifecycleAdapter.invoke(event);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnComponentLifecycleAdaptor(componentLifecycleAdapter);
            throw throwable;
        }
        this.returnComponentLifecycleAdaptor(componentLifecycleAdapter);
        return object;
    }

    public Class getObjectType() {
        return this.objectFactory.getObjectClass();
    }

    protected LifecycleAdapter createLifeCycleAdaptor() throws Exception {
        Object object = this.objectFactory.getInstance();
        if (this.wireObject.get()) {
            if (this.objectFactory.isSingleton()) {
                this.wireObject.set(false);
            }
            if (object instanceof ServiceAware) {
                ((ServiceAware)object).setService(this.getService());
            }
            if (this.objectFactory.isAutoWireObject()) {
                this.muleContext.getRegistry().applyProcessors(object);
            }
        }
        LifecycleAdapter lifecycleAdapter = this.lifecycleAdapterFactory != null ? this.lifecycleAdapterFactory.create(object, this, this.entryPointResolverSet, this.muleContext) : (this.objectFactory.isExternallyManagedLifecycle() ? new NullLifecycleAdapter(object, this, this.entryPointResolverSet, this.muleContext) : this.service.getModel().getLifecycleAdapterFactory().create(object, this, this.entryPointResolverSet, this.muleContext));
        lifecycleAdapter.initialise();
        return lifecycleAdapter;
    }

    protected abstract LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception;

    protected abstract void returnComponentLifecycleAdaptor(LifecycleAdapter var1) throws Exception;

    protected void doInitialise() throws InitialisationException {
        if (this.objectFactory == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("object factory"), (Initialisable)this);
        }
        this.objectFactory.initialise();
    }

    protected void doStart() throws MuleException {
        if (this.entryPointResolverSet == null) {
            this.entryPointResolverSet = this.service.getModel().getEntryPointResolverSet();
        }
    }

    protected void doDispose() {
    }

    public EntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    public BindingCollection getBindingCollection() {
        return this.bindingCollection;
    }

    public void setEntryPointResolverSet(EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    public void setBindingCollection(BindingCollection bindingCollection) {
        this.bindingCollection = bindingCollection;
    }

    public void setEntryPointResolvers(Collection entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        Iterator resolvers = entryPointResolvers.iterator();
        while (resolvers.hasNext()) {
            this.entryPointResolverSet.addEntryPointResolver((EntryPointResolver)resolvers.next());
        }
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public LifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(LifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }
}

