/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.i18n;

import java.util.Date;
import java.util.List;
import org.mule.AbstractExceptionListener;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.ClassUtils;
import org.mule.util.DateUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreMessages
extends MessageFactory {
    private static final CoreMessages factory = new CoreMessages();
    private static final String BUNDLE_PATH = CoreMessages.getBundlePath("core");

    public static Message versionNotSet() {
        return factory.createMessage(BUNDLE_PATH, 1);
    }

    public static Message serverStartedAt(long startDate) {
        return factory.createMessage(BUNDLE_PATH, 2, (Object)new Date(startDate));
    }

    public static Message serverShutdownAt(Date date) {
        return factory.createMessage(BUNDLE_PATH, 3, (Object)date);
    }

    public static Message agentsRunning() {
        return factory.createMessage(BUNDLE_PATH, 4);
    }

    public static Message notSet() {
        return factory.createMessage(BUNDLE_PATH, 5);
    }

    public static Message version() {
        String version = StringUtils.defaultString((String)MuleManifest.getProductVersion(), (String)CoreMessages.notSet().getMessage());
        return factory.createMessage(BUNDLE_PATH, 6, (Object)version);
    }

    public static Message shutdownNormally(Date date) {
        return factory.createMessage(BUNDLE_PATH, 7, (Object)date);
    }

    public static Message serverWasUpForDuration(long duration) {
        String formattedDuration = DateUtils.getFormattedDuration(duration);
        return factory.createMessage(BUNDLE_PATH, 8, (Object)formattedDuration);
    }

    public static Message configNotFoundUsage() {
        return factory.createMessage(BUNDLE_PATH, 9);
    }

    public static Message fatalErrorWhileRunning() {
        return factory.createMessage(BUNDLE_PATH, 10);
    }

    public static Message rootStackTrace() {
        return factory.createMessage(BUNDLE_PATH, 11);
    }

    public static Message exceptionStackIs() {
        return factory.createMessage(BUNDLE_PATH, 12);
    }

    public static Message messageIsOfType(Class<?> type) {
        return factory.createMessage(BUNDLE_PATH, 18, (Object)ClassUtils.getSimpleName(type));
    }

    public static Message fatalErrorInShutdown() {
        return factory.createMessage(BUNDLE_PATH, 20);
    }

    public static Message normalShutdown() {
        return factory.createMessage(BUNDLE_PATH, 21);
    }

    public static Message none() {
        return factory.createMessage(BUNDLE_PATH, 22);
    }

    public static Message notClustered() {
        return factory.createMessage(BUNDLE_PATH, 23);
    }

    public static Message failedToRouterViaEndpoint(ImmutableEndpoint endpoint) {
        return factory.createMessage(BUNDLE_PATH, 30, (Object)endpoint);
    }

    public static Message cannotUseDisposedConnector() {
        return factory.createMessage(BUNDLE_PATH, 32);
    }

    public static Message connectorCausedError() {
        return CoreMessages.connectorCausedError(null);
    }

    public static Message connectorCausedError(Object connector) {
        return factory.createMessage(BUNDLE_PATH, 33, connector);
    }

    public static Message endpointIsNullForListener() {
        return factory.createMessage(BUNDLE_PATH, 34);
    }

    public static Message listenerAlreadyRegistered(EndpointURI endpointUri) {
        return factory.createMessage(BUNDLE_PATH, 35, (Object)endpointUri);
    }

    public static Message objectAlreadyInitialised(String name) {
        return factory.createMessage(BUNDLE_PATH, 37, (Object)name);
    }

    public static Message componentCausedErrorIs(Object component) {
        return factory.createMessage(BUNDLE_PATH, 38, component);
    }

    public static Message objectFailedToInitialise(String string) {
        return factory.createMessage(BUNDLE_PATH, 40, (Object)string);
    }

    public static Message failedToStop(String string) {
        return factory.createMessage(BUNDLE_PATH, 41, (Object)string);
    }

    public static Message failedToStart(String string) {
        return factory.createMessage(BUNDLE_PATH, 42, (Object)string);
    }

    public static Message proxyPoolTimedOut() {
        return factory.createMessage(BUNDLE_PATH, 43);
    }

    public static Message failedToGetPooledObject() {
        return factory.createMessage(BUNDLE_PATH, 44);
    }

    public static Message objectIsNull(String string) {
        return factory.createMessage(BUNDLE_PATH, 45, (Object)string);
    }

    public static Message componentNotRegistered(String name) {
        return factory.createMessage(BUNDLE_PATH, 46, (Object)name);
    }

    public static Message failedtoRegisterOnEndpoint(String name, Object endpointURI) {
        return factory.createMessage(BUNDLE_PATH, 47, (Object)name, endpointURI);
    }

    public static Message failedToUnregister(String name, Object endpointURI) {
        return factory.createMessage(BUNDLE_PATH, 48, (Object)name, endpointURI);
    }

    public static Message endpointIsMalformed(String endpoint) {
        return factory.createMessage(BUNDLE_PATH, 51, (Object)endpoint);
    }

    public static Message transformFailedBeforeFilter() {
        return factory.createMessage(BUNDLE_PATH, 52);
    }

    public static Message transformUnexpectedType(Class<?> class1, Class<?> returnClass) {
        return factory.createMessage(BUNDLE_PATH, 53, (Object)ClassUtils.getSimpleName(class1), (Object)ClassUtils.getSimpleName(returnClass));
    }

    public static Message transformUnexpectedType(DataType dt1, DataType dt2) {
        return factory.createMessage(BUNDLE_PATH, 53, (Object)dt1, (Object)dt2);
    }

    public static Message transformOnObjectUnsupportedTypeOfEndpoint(String name, Class<?> class1, ImmutableEndpoint endpoint) {
        return factory.createMessage(BUNDLE_PATH, 54, (Object)name, (Object)StringMessageUtils.toString(class1), (Object)(endpoint != null ? endpoint.getEndpointURI() : null));
    }

    public static Message transformFailedFrom(Class<?> clazz) {
        return factory.createMessage(BUNDLE_PATH, 55, (Object)clazz);
    }

    public static Message encryptionStrategyNotSet() {
        return factory.createMessage(BUNDLE_PATH, 56);
    }

    public static Message failedToLoadTransformer(String direction, String transformer) {
        return factory.createMessage(BUNDLE_PATH, 57, (Object)direction, (Object)transformer);
    }

    public static Message failedToLoad(String string) {
        return factory.createMessage(BUNDLE_PATH, 58, (Object)string);
    }

    public static Message messageNotSupportedByAdapter(String string, String string2) {
        return factory.createMessage(BUNDLE_PATH, 59, (Object)string, (Object)string2);
    }

    public static Message tooManyAcceptableMethodsOnObjectForTypes(Object object, Object types) {
        return factory.createMessage(BUNDLE_PATH, 60, (Object)StringMessageUtils.toString(object), (Object)StringMessageUtils.toString(types));
    }

    public static Message cannotSetPropertyOnObjectWithParamType(String property, Class<?> class1, Class<?> class2) {
        return factory.createMessage(BUNDLE_PATH, 61, (Object)property, (Object)StringMessageUtils.toString(class1), (Object)StringMessageUtils.toString(class2));
    }

    public static Message noComponentForEndpoint() {
        return factory.createMessage(BUNDLE_PATH, 64);
    }

    public static Message failedToCreate(String string) {
        return factory.createMessage(BUNDLE_PATH, 65, (Object)string);
    }

    public static Message noCorrelationId() {
        return factory.createMessage(BUNDLE_PATH, 66);
    }

    public static Object failedToDispose(String string) {
        return factory.createMessage(BUNDLE_PATH, 67, (Object)string);
    }

    public static Message failedToInvoke(String string) {
        return factory.createMessage(BUNDLE_PATH, 68, (Object)string);
    }

    public static Message cannotReadPayloadAsBytes(String type) {
        return factory.createMessage(BUNDLE_PATH, 69, (Object)type);
    }

    public static Message cannotReadPayloadAsString(String type) {
        return factory.createMessage(BUNDLE_PATH, 70, (Object)type);
    }

    public static Message routingFailedOnEndpoint(Service service, ImmutableEndpoint endpoint) {
        EndpointURI endpointURI = null;
        if (endpoint != null) {
            endpointURI = endpoint.getEndpointURI();
        }
        return factory.createMessage(BUNDLE_PATH, 72, (Object)service.getName(), (Object)endpointURI);
    }

    public static Message cannotInstanciateFinder(String serviceFinder) {
        return factory.createMessage(BUNDLE_PATH, 73, (Object)serviceFinder);
    }

    public static Message failedToCreateObjectWith(String string, Object arg) {
        return factory.createMessage(BUNDLE_PATH, 74, (Object)string, arg);
    }

    public static Message objectNotSetInService(Object object, Object service) {
        return factory.createMessage(BUNDLE_PATH, 75, object, service);
    }

    public static Message objectNotFound(String object) {
        return factory.createMessage(BUNDLE_PATH, 76, (Object)object);
    }

    public static Message objectNotFound(String type, String object) {
        return factory.createMessage(BUNDLE_PATH, 76, (Object)(type + ": " + object));
    }

    public static Message transactionMarkedForRollback() {
        return factory.createMessage(BUNDLE_PATH, 77);
    }

    public static Message transactionCannotBindToNullKey() {
        return factory.createMessage(BUNDLE_PATH, 78);
    }

    public static Message transactionCannotBindNullResource() {
        return factory.createMessage(BUNDLE_PATH, 79);
    }

    public static Message transactionSingleResourceOnly() {
        return factory.createMessage(BUNDLE_PATH, 80);
    }

    public static Message noCurrentEventForTransformer() {
        return factory.createMessage(BUNDLE_PATH, 81);
    }

    public static Message objectNotRegistered(String type, String name) {
        return factory.createMessage(BUNDLE_PATH, 82, (Object)type, (Object)name);
    }

    public static Message failedToSetPropertiesOn(String string) {
        return factory.createMessage(BUNDLE_PATH, 83, (Object)string);
    }

    public static Message failedToCreateConnectorFromUri(EndpointURI uri) {
        return factory.createMessage(BUNDLE_PATH, 84, (Object)uri);
    }

    public static Message initialisationFailure(String string) {
        return factory.createMessage(BUNDLE_PATH, 85, (Object)string);
    }

    public static Message failedToCreateEndpointFromLocation(String string) {
        return factory.createMessage(BUNDLE_PATH, 87, (Object)string);
    }

    public static Message managerAlreadyStarted() {
        return factory.createMessage(BUNDLE_PATH, 88);
    }

    public static Message noEndpointsForRouter() {
        return factory.createMessage(BUNDLE_PATH, 89);
    }

    public static Message responseTimedOutWaitingForId(int timeout, Object id) {
        return factory.createMessage(BUNDLE_PATH, 90, (Object)String.valueOf(timeout), id);
    }

    public static Message failedToRecevieWithTimeout(Object endpoint, long timeout) {
        return factory.createMessage(BUNDLE_PATH, 93, endpoint, (Object)String.valueOf(timeout));
    }

    public static Message failedToWriteMessageToStore(Object id, String storeName) {
        return factory.createMessage(BUNDLE_PATH, 94, id, (Object)storeName);
    }

    public static Message failedToReadFromStore(String absolutePath) {
        return factory.createMessage(BUNDLE_PATH, 95, (Object)absolutePath);
    }

    public static Message cannotStartTransaction(String string) {
        return factory.createMessage(BUNDLE_PATH, 96, (Object)string);
    }

    public static Message transactionCommitFailed() {
        return factory.createMessage(BUNDLE_PATH, 97);
    }

    public static Message transactionRollbackFailed() {
        return factory.createMessage(BUNDLE_PATH, 98);
    }

    public static Message transactionCannotReadState() {
        return factory.createMessage(BUNDLE_PATH, 99);
    }

    public static Message transactionResourceAlreadyListedForKey(Object key) {
        return factory.createMessage(BUNDLE_PATH, 100, key);
    }

    public static Message noOutboundRouterSetOn(String string) {
        return factory.createMessage(BUNDLE_PATH, 101, (Object)string);
    }

    public static Message transactionAvailableButActionIs(String string) {
        return factory.createMessage(BUNDLE_PATH, 103, (Object)string);
    }

    public static Message transactionNotAvailableButActionIs(String string) {
        return factory.createMessage(BUNDLE_PATH, 104, (Object)string);
    }

    public static Message noCatchAllEndpointSet() {
        return factory.createMessage(BUNDLE_PATH, 105);
    }

    public static Message interruptedQueuingEventFor(Object object) {
        return factory.createMessage(BUNDLE_PATH, 106, object);
    }

    public static Message transactionCannotUnbind() {
        return factory.createMessage(BUNDLE_PATH, 107);
    }

    public static Message transactionAlreadyBound() {
        return factory.createMessage(BUNDLE_PATH, 108);
    }

    public static Message methodWithParamsNotFoundOnObject(String method, Object class1, Class<?> class2) {
        return factory.createMessage(BUNDLE_PATH, 109, (Object)method, (Object)StringMessageUtils.toString(class1), (Object)StringMessageUtils.toString(class2));
    }

    public static Message transformFailed(String from, String to) {
        return factory.createMessage(BUNDLE_PATH, 110, (Object)from, (Object)to);
    }

    public static Message cryptoFailure() {
        return factory.createMessage(BUNDLE_PATH, 112);
    }

    public static Message schemeNotCompatibleWithConnector(String scheme, Class<?> expectedClass) {
        return factory.createMessage(BUNDLE_PATH, 115, (Object)scheme, (Object)expectedClass);
    }

    public static Message noEntryPointFoundWithArgs(Object object, Object args) {
        return factory.createMessage(BUNDLE_PATH, 116, (Object)StringMessageUtils.toString(object), (Object)StringMessageUtils.toString(args));
    }

    public static Message authNoSecurityProvider(String providerName) {
        return factory.createMessage(BUNDLE_PATH, 117, (Object)providerName);
    }

    public static Message transactionCanOnlyBindToResources(String string) {
        return factory.createMessage(BUNDLE_PATH, 120, (Object)string);
    }

    public static Message cannotLoadFromClasspath(String string) {
        return factory.createMessage(BUNDLE_PATH, 122, (Object)string);
    }

    public static Message failedToReadPayload() {
        return factory.createMessage(BUNDLE_PATH, 124);
    }

    public static Message endpointNotFound(String endpoint) {
        return factory.createMessage(BUNDLE_PATH, 126, (Object)endpoint);
    }

    public static Message eventProcessingFailedFor(String name) {
        return factory.createMessage(BUNDLE_PATH, 127, (Object)name);
    }

    public static Message failedToDispatchToReplyto(ImmutableEndpoint endpoint) {
        return factory.createMessage(BUNDLE_PATH, 128, (Object)endpoint);
    }

    public static Message authTypeNotRecognised(String string) {
        return factory.createMessage(BUNDLE_PATH, 131, (Object)string);
    }

    public static Message authSecurityManagerNotSet() {
        return factory.createMessage(BUNDLE_PATH, 132);
    }

    public static Message authSetButNoContext(String name) {
        return factory.createMessage(BUNDLE_PATH, 133, (Object)name);
    }

    public static Message authDeniedOnEndpoint(EndpointURI endpointURI) {
        return factory.createMessage(BUNDLE_PATH, 134, (Object)endpointURI);
    }

    public static Message authFailedForUser(Object user) {
        return factory.createMessage(BUNDLE_PATH, 135, user);
    }

    public static Message authEndpointMustSendOrReceive() {
        return factory.createMessage(BUNDLE_PATH, 136);
    }

    public static Message transactionManagerAlreadySet() {
        return factory.createMessage(BUNDLE_PATH, 140);
    }

    public static Message failedToCreateManagerInstance(String className) {
        return factory.createMessage(BUNDLE_PATH, 144, (Object)className);
    }

    public static Message failedToClone(String string) {
        return factory.createMessage(BUNDLE_PATH, 145, (Object)string);
    }

    public static Message exceptionOnConnectorNoExceptionListener(String name) {
        return factory.createMessage(BUNDLE_PATH, 146, (Object)name);
    }

    public static Message uniqueIdNotSupportedByAdapter(String name) {
        return factory.createMessage(BUNDLE_PATH, 147, (Object)name);
    }

    public static Message serverNotificationManagerNotEnabled() {
        return factory.createMessage(BUNDLE_PATH, 150);
    }

    public static Message failedToScheduleWork() {
        return factory.createMessage(BUNDLE_PATH, 151);
    }

    public static Message authNoCredentials() {
        return factory.createMessage(BUNDLE_PATH, 152);
    }

    public static Message valueIsInvalidFor(String value, String parameter) {
        return factory.createMessage(BUNDLE_PATH, 154, (Object)value, (Object)parameter);
    }

    public static Message connectorWithProtocolNotRegistered(String scheme) {
        return factory.createMessage(BUNDLE_PATH, 156, (Object)scheme);
    }

    public static Message propertyIsNotSupportedType(String property, Class<?> expected, Class<?> actual) {
        return factory.createMessage(BUNDLE_PATH, 157, (Object)property, (Object)StringMessageUtils.toString(expected), (Object)StringMessageUtils.toString(actual));
    }

    public static Message propertyIsNotSupportedType(String property, Class<?>[] expected, Class<?> actual) {
        return factory.createMessage(BUNDLE_PATH, 157, (Object)property, (Object)StringMessageUtils.toString(expected), (Object)StringMessageUtils.toString(actual));
    }

    public static Message containerAlreadyRegistered(String name) {
        return factory.createMessage(BUNDLE_PATH, 155, (Object)name);
    }

    public static Message resourceManagerNotStarted() {
        return factory.createMessage(BUNDLE_PATH, 161);
    }

    public static Message resourceManagerDirty() {
        return factory.createMessage(BUNDLE_PATH, 162);
    }

    public static Message resourceManagerNotReady() {
        return factory.createMessage(BUNDLE_PATH, 163);
    }

    public static Message reconnectStrategyFailed(Class<?> strategy, String description) {
        return factory.createMessage(BUNDLE_PATH, 164, (Object)StringMessageUtils.toString(strategy), (Object)description);
    }

    public static Message cannotSetObjectOnceItHasBeenSet(String string) {
        return factory.createMessage(BUNDLE_PATH, 165, (Object)string);
    }

    public static Message eventTypeNotRecognised(String string) {
        return factory.createMessage(BUNDLE_PATH, 166, (Object)string);
    }

    public static Message componentIsStopped(String name) {
        return factory.createMessage(BUNDLE_PATH, 167, (Object)name);
    }

    public static Message propertyIsNotSetOnEvent(String property) {
        return factory.createMessage(BUNDLE_PATH, 168, (Object)property);
    }

    public static Message descriptorAlreadyExists(String name) {
        return factory.createMessage(BUNDLE_PATH, 171, (Object)name);
    }

    public static Message failedToInvokeRestService(String service) {
        return factory.createMessage(BUNDLE_PATH, 172, (Object)service);
    }

    public static Message authNoEncryptionStrategy(String strategyName) {
        return factory.createMessage(BUNDLE_PATH, 174, (Object)strategyName);
    }

    public static Message headerMalformedValueIs(String header, String value) {
        return factory.createMessage(BUNDLE_PATH, 175, (Object)header, (Object)value);
    }

    public static Message transformOnObjectNotOfSpecifiedType(String name, Object expectedType) {
        return factory.createMessage(BUNDLE_PATH, 177, (Object)name, expectedType);
    }

    public static Message cannotUseTxAndRemoteSync() {
        return factory.createMessage(BUNDLE_PATH, 178);
    }

    public static Message failedToBuildMessage() {
        return factory.createMessage(BUNDLE_PATH, 180);
    }

    public static Message propertiesNotSet(String string) {
        return factory.createMessage(BUNDLE_PATH, 183, (Object)string);
    }

    public static Message objectNotOfCorrectType(Class<?> actualClass, Class<?>[] expectedClass) {
        return factory.createMessage(BUNDLE_PATH, 185, (Object)StringMessageUtils.toString(actualClass), (Object)StringMessageUtils.toString(expectedClass));
    }

    public static Message objectNotOfCorrectType(Class<?> actualClass, Class<?> expectedClass) {
        return factory.createMessage(BUNDLE_PATH, 185, (Object)StringMessageUtils.toString(actualClass), (Object)StringMessageUtils.toString(expectedClass));
    }

    public static Message failedToConvertStringUsingEncoding(String encoding) {
        return factory.createMessage(BUNDLE_PATH, 188, (Object)encoding);
    }

    public static Message propertyHasInvalidValue(String property, Object value) {
        return factory.createMessage(BUNDLE_PATH, 189, (Object)property, value);
    }

    public static Message schemeCannotChangeForRouter(String scheme, String scheme2) {
        return factory.createMessage(BUNDLE_PATH, 192, (Object)scheme, (Object)scheme2);
    }

    public static Message days() {
        return factory.createMessage(BUNDLE_PATH, 193);
    }

    public static Message hours() {
        return factory.createMessage(BUNDLE_PATH, 194);
    }

    public static Message minutes() {
        return factory.createMessage(BUNDLE_PATH, 195);
    }

    public static Message seconds() {
        return factory.createMessage(BUNDLE_PATH, 196);
    }

    public static Message templateCausedMalformedEndpoint(String uri, String newUri) {
        return factory.createMessage(BUNDLE_PATH, 197, (Object)uri, (Object)newUri);
    }

    public static Message couldNotDetermineDestinationComponentFromEndpoint(String endpoint) {
        return factory.createMessage(BUNDLE_PATH, 198, (Object)endpoint);
    }

    public static Message sessionValueIsMalformed(String string) {
        return factory.createMessage(BUNDLE_PATH, 201, (Object)string);
    }

    public static Message streamingFailedNoStream() {
        return factory.createMessage(BUNDLE_PATH, 205);
    }

    public static Message connectorSchemeIncompatibleWithEndpointScheme(Object expected, Object actual) {
        return factory.createMessage(BUNDLE_PATH, 206, expected, actual);
    }

    public static Message failedToReadAttachment(String string) {
        return factory.createMessage(BUNDLE_PATH, 207, (Object)string);
    }

    public static Message failedToInitSecurityProvider(String providerClass) {
        return factory.createMessage(BUNDLE_PATH, 208, (Object)providerClass);
    }

    public static Message streamingNotSupported(String protocol) {
        return factory.createMessage(BUNDLE_PATH, 209, (Object)protocol);
    }

    public static Message streamingComponentMustHaveOneEndpoint(String name) {
        return factory.createMessage(BUNDLE_PATH, 210, (Object)name);
    }

    public static Message streamingFailedForEndpoint(String string) {
        return factory.createMessage(BUNDLE_PATH, 212, (Object)string);
    }

    public static Message streamingEndpointsDoNotSupportTransformers() {
        return factory.createMessage(BUNDLE_PATH, 213);
    }

    public static Message streamingEndpointsMustBeUsedWithStreamingModel() {
        return factory.createMessage(BUNDLE_PATH, 214);
    }

    public static Message tooManyMatchingMethodsOnObjectWhichReturn(Object object, Object returnType) {
        return factory.createMessage(BUNDLE_PATH, 216, (Object)StringMessageUtils.toString(object), (Object)StringMessageUtils.toString(returnType));
    }

    public static Message failedToSetProxyOnService(Object proxy, Class<?> routerClass) {
        return factory.createMessage(BUNDLE_PATH, 217, proxy, (Object)routerClass);
    }

    public static Message mustSetMethodNamesOnBinding() {
        return factory.createMessage(BUNDLE_PATH, 218);
    }

    public static Message cannotFindBindingForMethod(String name) {
        return factory.createMessage(BUNDLE_PATH, 219, (Object)name);
    }

    public static Message noMatchingMethodsOnObjectReturning(Object object, Class<?> returnType) {
        return factory.createMessage(BUNDLE_PATH, 220, (Object)StringMessageUtils.toString(object), (Object)StringMessageUtils.toString(returnType));
    }

    public static Message moreThanOneConnectorWithProtocol(String protocol, String connectors) {
        return factory.createMessage(BUNDLE_PATH, 221, (Object)protocol, (Object)connectors);
    }

    public static Message failedToGetOutputStream() {
        return factory.createMessage(BUNDLE_PATH, 223);
    }

    public static Message noEntryPointFoundForNoArgsMethod(Object component, String methodName) {
        return factory.createMessage(BUNDLE_PATH, 224, component, (Object)methodName);
    }

    public static Message noDelegateClassAndMethodProvidedForNoArgsWrapper() {
        return factory.createMessage(BUNDLE_PATH, 225);
    }

    public static Message noDelegateClassIfDelegateInstanceSpecified() {
        return factory.createMessage(BUNDLE_PATH, 226);
    }

    public static Message noServiceTransportDescriptor(String protocol) {
        return factory.createMessage(BUNDLE_PATH, 227, (Object)protocol);
    }

    public static Message failedToInvokeLifecycle(String phaseName, Object object) {
        return factory.createMessage(BUNDLE_PATH, 228, (Object)phaseName, object);
    }

    public static Message unrecognisedServiceType(String type) {
        return factory.createMessage(BUNDLE_PATH, 229, (Object)type);
    }

    public static Message serviceFinderCantFindService(String name) {
        return factory.createMessage(BUNDLE_PATH, 230, (Object)name);
    }

    public static Message inboundRouterMustUseInboundEndpoints(InboundRouterCollection router, ImmutableEndpoint endpoint) {
        return factory.createMessage(BUNDLE_PATH, 232, (Object)endpoint, (Object)router);
    }

    public static Message outboundRouterMustUseOutboudEndpoints(OutboundRouter router, ImmutableEndpoint endpoint) {
        return factory.createMessage(BUNDLE_PATH, 233, (Object)endpoint, (Object)router);
    }

    public static Message responseRouterMustUseInboundEndpoints(ResponseRouterCollection router, ImmutableEndpoint endpoint) {
        return factory.createMessage(BUNDLE_PATH, 234, (Object)endpoint, (Object)router);
    }

    public static Message exceptionListenerMustUseOutboundEndpoint(AbstractExceptionListener exceptionListener, ImmutableEndpoint endpoint) {
        return factory.createMessage(BUNDLE_PATH, 235, (Object)endpoint, (Object)exceptionListener);
    }

    public static Message productInformation() {
        String notset = CoreMessages.notSet().getMessage();
        return factory.createMessage(BUNDLE_PATH, 236, (Object)StringUtils.defaultString((String)MuleManifest.getProductDescription(), (String)notset), (Object)StringUtils.defaultString((String)MuleManifest.getProductVersion(), (String)notset), (Object)(StringUtils.defaultString((String)MuleManifest.getVendorName(), (String)notset) + " " + StringUtils.defaultString((String)MuleManifest.getVendorUrl(), (String)notset)));
    }

    public static Message noTransformerFoundForMessage(DataType input, DataType output) {
        return factory.createMessage(BUNDLE_PATH, 237, (Object)input, (Object)output);
    }

    public static Message errorReadingStream() {
        return factory.createMessage(BUNDLE_PATH, 238);
    }

    public static Message noEntryPointFoundForNoArgsMethodUsingResolver(Object component, String methodName, EntryPointResolver resolver) {
        return factory.createMessage(BUNDLE_PATH, 239, (Object)methodName, component, (Object)resolver);
    }

    public static Message noEntryPointFoundWithArgsUsingResolver(Object object, Object args, EntryPointResolver resolver) {
        return factory.createMessage(BUNDLE_PATH, 240, (Object)StringMessageUtils.toString(object), (Object)StringMessageUtils.toString(args), (Object)resolver);
    }

    public static Message noMatchingMethodsOnObjectReturningUsingResolver(Object object, Class<?> returnType, EntryPointResolver resolver) {
        return factory.createMessage(BUNDLE_PATH, 241, (Object)StringMessageUtils.toString(object), (Object)returnType.getClass().getName(), (Object)resolver);
    }

    public static Message tooManyAcceptableMethodsOnObjectUsingResolverForTypes(Object object, Object types, EntryPointResolver resolver) {
        return factory.createMessage(BUNDLE_PATH, 242, (Object)StringMessageUtils.toString(object), (Object)StringMessageUtils.toString(types), (Object)resolver);
    }

    public static Message tooManyMatchingMethodsOnObjectUsingResolverWhichReturn(Object object, Object returnType, EntryPointResolver resolver) {
        return factory.createMessage(BUNDLE_PATH, 243, (Object)StringMessageUtils.toString(returnType), (Object)StringMessageUtils.toString(object), (Object)resolver);
    }

    public static Message objectDoesNotImplementInterface(Object object, Class<?> interfaceClass) {
        return factory.createMessage(BUNDLE_PATH, 244, (Object)StringMessageUtils.toString(object), (Object)interfaceClass);
    }

    public static Message invocationSuccessfulCantSetError() {
        return factory.createMessage(BUNDLE_PATH, 245);
    }

    public static Message noMatchingMethodsOnObjectCalledUsingResolver(Object object, String methodName, EntryPointResolver resolver) {
        return factory.createMessage(BUNDLE_PATH, 246, (Object)StringMessageUtils.toString(object), (Object)methodName, (Object)resolver);
    }

    public static Message noJtaTransactionAvailable(Thread callingThread) {
        return factory.createMessage(BUNDLE_PATH, 247, (Object)StringUtils.defaultString((String)callingThread.toString()));
    }

    public static Message notMuleXaTransaction(Object tx) {
        return factory.createMessage(BUNDLE_PATH, 248, (Object)tx.getClass());
    }

    public static Message noServiceQueueTimeoutSet(Service service) {
        return factory.createMessage(BUNDLE_PATH, 249, (Object)service);
    }

    public static Message failedToProcessExtractorFunction(String name) {
        return factory.createMessage(BUNDLE_PATH, 250, (Object)name);
    }

    public static Message expressionEvaluatorNotRegistered(String key) {
        return factory.createMessage(BUNDLE_PATH, 251, (Object)key);
    }

    public static Message objectAlreadyExists(String key) {
        return factory.createMessage(BUNDLE_PATH, 252, (Object)key);
    }

    public static Message noMuleTransactionAvailable() {
        return factory.createMessage(BUNDLE_PATH, 253);
    }

    public static Message objectAlreadyRegistered(String name, Object origObject, Object newObject) {
        return factory.createMessage(BUNDLE_PATH, 254, (Object)name, (Object)(origObject + "." + origObject.getClass()), (Object)(newObject + "." + newObject.getClass()));
    }

    public static Message transformerNotImplementDiscoverable(Transformer transformer) {
        return factory.createMessage(BUNDLE_PATH, 255, (Object)transformer);
    }

    public static Message transformHasMultipleMatches(Class<?> input, Class<?> output, Transformer transformer1, Transformer transformer2) {
        return factory.createMessage(BUNDLE_PATH, 256, input, output, transformer1.getName() + "(" + transformer1.getClass() + ")", transformer2.getName() + "(" + transformer2.getClass() + ")");
    }

    public static Message configurationBuilderSuccess(ConfigurationBuilder configurationBuilder, int numResources) {
        return factory.createMessage(BUNDLE_PATH, 257, (Object)configurationBuilder.getClass().getName(), (Object)new Integer(numResources));
    }

    public static Message configurationBuilderSuccess(ConfigurationBuilder configurationBuilder, String resources) {
        return factory.createMessage(BUNDLE_PATH, 258, (Object)configurationBuilder.getClass().getName(), (Object)resources);
    }

    public static Message configurationBuilderNoMatching(String resource) {
        return factory.createMessage(BUNDLE_PATH, 259, (Object)resource);
    }

    public static Message configurationBuilderError(ConfigurationBuilder configurationBuilder) {
        return factory.createMessage(BUNDLE_PATH, 260, (Object)StringMessageUtils.toString(configurationBuilder.getClass()));
    }

    public static Message nestedRetry() {
        return factory.createMessage(BUNDLE_PATH, 261);
    }

    public static Message expressionEvaluatorReturnedNull(String name, String expr) {
        return factory.createMessage(BUNDLE_PATH, 263, (Object)name, (Object)expr);
    }

    public static Message expressionInvalidForProperty(String property, String expr) {
        return factory.createMessage(BUNDLE_PATH, 264, (Object)property, (Object)expr);
    }

    public static Message expressionMalformed(String expr, String eval) {
        return factory.createMessage(BUNDLE_PATH, 265, (Object)expr, (Object)eval);
    }

    public static Message correlationTimedOut(Object groupId) {
        return factory.createMessage(BUNDLE_PATH, 266, groupId);
    }

    public static Message transformerInvalidReturnType(Class<?> clazz, String transformerName) {
        return factory.createMessage(BUNDLE_PATH, 267, (Object)clazz, (Object)transformerName);
    }

    public static Message transactionFactoryIsMandatory(String action) {
        return factory.createMessage(BUNDLE_PATH, 269, (Object)action);
    }

    public static Message failedToCreateProxyFor(Object target) {
        return factory.createMessage(BUNDLE_PATH, 270, target);
    }

    public static Message authorizationAttemptFailed() {
        return factory.createMessage(BUNDLE_PATH, 271);
    }

    public static Message retryPolicyExhausted(RetryPolicyTemplate policy) {
        return factory.createMessage(BUNDLE_PATH, 272, (Object)policy);
    }

    public static Message notConnectedYet(String what) {
        return factory.createMessage(BUNDLE_PATH, 273, (Object)what);
    }

    public static Message stopPausedSedaServiceNonPeristentQueueMessageLoss(int num, Service service) {
        return factory.createMessage(BUNDLE_PATH, 274, (Object)num, (Object)service.getName());
    }

    public static Message splitMessageNoEndpointMatch(List endpoints, Object messagePart) {
        return factory.createMessage(BUNDLE_PATH, 275, (Object)StringMessageUtils.toString(endpoints), messagePart);
    }

    public static Message expressionResultWasNull(String expression) {
        return factory.createMessage(BUNDLE_PATH, 276, (Object)expression);
    }

    public static Message propertyDoesNotExistOnObject(String property, Object object) {
        return factory.createMessage(BUNDLE_PATH, 277, (Object)property, object);
    }

    public static Message commitTxButNoResource(Transaction tx) {
        return factory.createMessage(BUNDLE_PATH, 300, (Object)tx);
    }

    public static Message rollbackTxButNoResource(Transaction tx) {
        return factory.createMessage(BUNDLE_PATH, 301, (Object)tx);
    }

    public static Message cannotCopyStreamPayload(String streamType) {
        return factory.createMessage(BUNDLE_PATH, 302, (Object)streamType);
    }

    public static Message propertiesOrNotSet(String name, String properties) {
        return factory.createMessage(BUNDLE_PATH, 303, (Object)name, (Object)properties);
    }

    public static Message transforemrMapBeanClassNotSet() {
        return factory.createMessage(BUNDLE_PATH, 304);
    }
}

