/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.config.MuleManifest;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOutboundEndpoint
extends AbstractEndpoint
implements OutboundEndpoint {
    private static final long serialVersionUID = 8860985949279708638L;
    private List<String> responseProperties = new ArrayList<String>();

    public DefaultOutboundEndpoint(Connector connector, EndpointURI endpointUri, List transformers, List responseTransformers, String name, Map properties, TransactionConfig transactionConfig, Filter filter, boolean deleteUnacceptedMessage, EndpointSecurityFilter securityFilter, boolean synchronous, int responseTimeout, String initialState, String endpointEncoding, String endpointBuilderName, MuleContext muleContext, RetryPolicyTemplate retryPolicyTemplate, String responsePropertiesList) {
        super(connector, endpointUri, transformers, responseTransformers, name, properties, transactionConfig, filter, deleteUnacceptedMessage, securityFilter, synchronous, responseTimeout, initialState, endpointEncoding, endpointBuilderName, muleContext, retryPolicyTemplate);
        this.responseProperties.add("MULE_CORRELATION_ID");
        this.responseProperties.add("MULE_CORRELATION_GROUP_SIZE");
        this.responseProperties.add("MULE_CORRELATION_SEQUENCE");
        String[] props = StringUtils.splitAndTrim(responsePropertiesList, ",");
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                this.responseProperties.add(props[i]);
            }
        }
    }

    @Override
    public void dispatch(MuleEvent event) throws DispatchException {
        if (this.getConnector() == null) {
            throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
        }
        this.getConnector().dispatch(this, event);
    }

    @Override
    public MuleMessage send(MuleEvent event) throws DispatchException {
        if (this.getConnector() != null) {
            return this.getConnector().send(this, event);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
    }

    @Override
    public List<String> getResponseProperties() {
        return this.responseProperties;
    }
}

