/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.registry.Registry;
import org.mule.lifecycle.phases.NotInLifecyclePhase;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericLifecycleManager
implements LifecycleManager {
    private static final Log logger = LogFactory.getLog(GenericLifecycleManager.class);
    protected static final NotInLifecyclePhase notInLifecyclePhase = new NotInLifecyclePhase();
    protected String currentPhase = notInLifecyclePhase.getName();
    protected String executingPhase = null;
    protected ListOrderedSet lifecycles = new ListOrderedSet();
    protected Map<String, Integer> index = new HashMap<String, Integer>(6);
    protected Set completedPhases = new LinkedHashSet(6);

    @Override
    public Set<LifecyclePhase> getLifecycles() {
        return this.lifecycles;
    }

    @Override
    public void setLifecycles(Set<LifecyclePhase> lifecycles) {
        for (LifecyclePhase phase : lifecycles) {
            this.registerLifecycle(phase);
        }
    }

    @Override
    public void registerLifecycle(LifecyclePhase phase) {
        this.index.put(phase.getName(), this.lifecycles.size());
        this.lifecycles.add((Object)phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePhase(MuleContext muleContext, String phase) throws MuleException {
        if (this.currentPhase.equalsIgnoreCase(phase)) {
            logger.debug((Object)("Already in lifecycle phase: " + phase));
            return;
        }
        LifecyclePhase li = this.lookupPhase(phase);
        if (!li.isPhaseSupported(this.currentPhase)) {
            throw new IllegalStateException("Lifecycle phase: " + phase + " does not support current phase: " + this.currentPhase + ". Phases supported are: " + StringMessageUtils.toString(li.getSupportedPhases()));
        }
        try {
            this.setExecutingPhase(phase);
            li.applyLifecycle(muleContext.getRegistry());
            this.setCurrentPhase(li);
            Object var5_4 = null;
            this.setExecutingPhase(null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setExecutingPhase(null);
            throw throwable;
        }
    }

    @Override
    public LifecyclePhase applyPhase(Registry registry, String phase) throws MuleException {
        LifecyclePhase li = this.lookupPhase(phase);
        li.applyLifecycle(registry);
        return li;
    }

    @Override
    public void applyPhase(Object object, String phase) throws MuleException {
        LifecyclePhase li = this.lookupPhase(phase);
        li.applyLifecycle(object);
    }

    @Override
    public void applyPhases(Object object, String phase) throws MuleException {
        int current = this.index.get(this.currentPhase);
        int end = this.index.get(phase);
        if (end < current) {
            logger.warn((Object)("Phase: " + phase + " has alredy been fired for this object"));
            return;
        }
        ++current;
        while (current <= end) {
            LifecyclePhase li = (LifecyclePhase)this.lifecycles.get(current);
            li.applyLifecycle(object);
            ++current;
        }
    }

    @Override
    public String getCurrentPhase() {
        return this.currentPhase;
    }

    @Override
    public String getExecutingPhase() {
        return this.executingPhase;
    }

    protected synchronized void setCurrentPhase(LifecyclePhase phase) {
        this.completedPhases.add(phase.getName());
        this.completedPhases.remove(phase.getOppositeLifecyclePhase());
        this.currentPhase = phase.getName();
    }

    protected synchronized void setExecutingPhase(String phase) {
        this.executingPhase = phase;
    }

    @Override
    public void reset() {
        this.setExecutingPhase(null);
        this.completedPhases.clear();
        this.setCurrentPhase(notInLifecyclePhase);
    }

    @Override
    public boolean isPhaseComplete(String phaseName) {
        return this.completedPhases.contains(phaseName);
    }

    @Override
    public void applyCompletedPhases(Object object) throws MuleException {
        LifecyclePhase lcp;
        Integer phaseIndex;
        logger.debug((Object)("applying lifecycle to " + object));
        for (Object completedPhase : this.completedPhases) {
            String phase = (String)completedPhase;
            phaseIndex = this.index.get(phase);
            lcp = (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("phase: " + lcp));
            }
            lcp.applyLifecycle(object);
        }
        if (this.getExecutingPhase() != null) {
            phaseIndex = this.index.get(this.getExecutingPhase());
            lcp = (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("and executing: " + lcp));
            }
            lcp.applyLifecycle(object);
        }
    }

    @Override
    public void checkPhase(String name) throws IllegalStateException {
        if (this.executingPhase != null) {
            if (name.equalsIgnoreCase(this.executingPhase)) {
                throw new IllegalStateException("Phase '" + name + "' is already currently being executed");
            }
            throw new IllegalStateException("Currently executing lifecycle phase: " + this.executingPhase);
        }
        Integer phaseIndex = this.index.get(name);
        if (phaseIndex == null) {
            throw new IllegalStateException("Phase does not exist: " + name);
        }
        LifecyclePhase phase = (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
        if (!phase.isPhaseSupported(this.currentPhase)) {
            throw new IllegalStateException("Lifecycle phase: " + this.currentPhase + " does not support current phase: " + name + ". Phases supported are: " + StringMessageUtils.toString(phase.getSupportedPhases()));
        }
    }

    protected LifecyclePhase lookupPhase(String phase) throws IllegalArgumentException {
        Integer phaseIndex = this.index.get(phase);
        if (phaseIndex == null) {
            throw new IllegalArgumentException("No lifecycle phase registered with name: " + phase);
        }
        return (LifecyclePhase)this.lifecycles.get(phaseIndex.intValue());
    }
}

