/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import java.io.Serializable;
import java.util.Date;
import org.mule.RequestContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.message.BaseMessageDTO;

public class ExceptionMessage
extends BaseMessageDTO {
    private static final long serialVersionUID = -538516243574950621L;
    private Throwable exception;
    private String componentName;
    private String endpointUri;
    private Date timeStamp;

    public ExceptionMessage(Object message, Throwable exception, String componentName, EndpointURI endpointUri) {
        super(ExceptionMessage.getAsSerializable(message));
        this.exception = exception;
        this.timeStamp = new Date();
        this.componentName = componentName;
        this.endpointUri = endpointUri.toString();
        MuleEventContext ctx = RequestContext.getEventContext();
        if (ctx != null) {
            MuleMessage msg = ctx.getMessage();
            for (String propertyKey : msg.getPropertyNames()) {
                this.setProperty(propertyKey, msg.getProperty(propertyKey));
            }
        }
    }

    protected static Serializable getAsSerializable(Object message) {
        if (message instanceof Serializable) {
            return (Serializable)message;
        }
        return message.toString();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getEndpoint() {
        return this.endpointUri;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "ExceptionMessage{payload=" + this.payload + ", context=" + this.properties + "exception=" + this.exception + ", componentName='" + this.componentName + "'" + ", endpointUri=" + this.endpointUri + ", timeStamp=" + this.timeStamp + "}";
    }
}

