/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import java.lang.reflect.Method;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Callable;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.InvocationResult;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.ClassUtils;

public class CallableEntryPointResolver
implements EntryPointResolver {
    protected static final Method callableMethod;

    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        if (component instanceof Callable) {
            Object result = ((Callable)component).onCall(context);
            return new InvocationResult(result, callableMethod);
        }
        InvocationResult result = new InvocationResult(0);
        result.setErrorMessage(ClassUtils.getClassName(this.getClass()) + ":" + CoreMessages.objectDoesNotImplementInterface(component, Callable.class).toString());
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CallableEntryPointResolver");
        sb.append("{}");
        return sb.toString();
    }

    static {
        try {
            callableMethod = Callable.class.getMethod("onCall", MuleEventContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Panic! No onCall(MuleEventContext) method found in the Callable interface."));
        }
    }
}

