/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import java.lang.reflect.Method;
import org.apache.commons.lang.BooleanUtils;
import org.mule.api.MuleEventContext;
import org.mule.api.lifecycle.Callable;
import org.mule.api.model.InvocationResult;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.AbstractEntryPointResolver;
import org.mule.util.ClassUtils;

public class MethodHeaderPropertyEntryPointResolver
extends AbstractEntryPointResolver {
    private String methodProperty = "method";

    public String getMethodProperty() {
        return this.methodProperty;
    }

    public void setMethodProperty(String methodProperty) {
        this.methodProperty = methodProperty;
    }

    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        String methodName;
        Method method;
        boolean ignoreMethod = BooleanUtils.toBoolean((Boolean)((Boolean)context.getMessage().removeProperty("MULE_IGNORE_METHOD")));
        if (ignoreMethod) {
            InvocationResult result = new InvocationResult(0);
            result.setErrorMessage("Property: MULE_IGNORE_METHOD was set so skipping this resolver: " + this);
            return result;
        }
        Object methodProp = context.getMessage().removeProperty(this.getMethodProperty());
        if (methodProp == null) {
            InvocationResult result = new InvocationResult(2);
            result.setErrorMessage(CoreMessages.propertyIsNotSetOnEvent(this.getMethodProperty()).toString());
            return result;
        }
        if (methodProp instanceof Method) {
            method = (Method)methodProp;
            methodName = method.getName();
        } else {
            methodName = methodProp.toString();
            method = this.getMethodByName(methodName, context);
        }
        if (method != null && method.getParameterTypes().length == 0) {
            return this.invokeMethod(component, method, ClassUtils.NO_ARGS_TYPE);
        }
        Object[] payload = this.getPayloadFromMessage(context);
        if (method == null) {
            Class[] classTypes = ClassUtils.getClassTypes(payload);
            method = ClassUtils.getMethod(component.getClass(), methodName, classTypes);
            if (method == null) {
                InvocationResult result = new InvocationResult(2);
                result.setErrorNoMatchingMethods(component, classTypes, this);
                return result;
            }
        }
        this.validateMethod(component, method);
        this.addMethodByName(method, context);
        return this.invokeMethod(component, method, payload);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateMethod(Object component, Method method) throws NoSuchMethodException {
        boolean fallback = component instanceof Callable;
        if (method != null) {
            try {
                component.getClass().getMethod(method.getName(), method.getParameterTypes());
                return;
            }
            catch (NoSuchMethodException e) {
                if (fallback) return;
                throw e;
            }
        } else {
            if (fallback) return;
            throw new NoSuchMethodException(CoreMessages.methodWithParamsNotFoundOnObject("null", "unknown", component.getClass()).toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MethodHeaderPropertyEntryPointResolver");
        sb.append("{methodHeader=").append(this.methodProperty);
        sb.append(", transformFirst=").append(this.isTransformFirst());
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }
}

