/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.mule.DefaultMessageCollection;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessageCollection;
import org.mule.util.ClassUtils;

public class EventGroup
implements Comparable,
Serializable {
    private static final long serialVersionUID = 953739659615692697L;
    public static final MuleEvent[] EMPTY_EVENTS_ARRAY = new MuleEvent[0];
    private final Object groupId;
    private final List<MuleEvent> events;
    private final long created = Utils.nanoTime();
    private final int expectedSize;

    public EventGroup(Object groupId) {
        this(groupId, -1);
    }

    public EventGroup(Object groupId, int expectedSize) {
        this.events = new ArrayList<MuleEvent>(expectedSize > 0 ? expectedSize : 10);
        this.expectedSize = expectedSize;
        this.groupId = groupId;
    }

    public int compareTo(Object o) {
        EventGroup other = (EventGroup)o;
        Object otherId = other.getGroupId();
        if (this.groupId instanceof Comparable && otherId instanceof Comparable) {
            return ((Comparable)this.groupId).compareTo(otherId);
        }
        long diff = this.created - other.getCreated();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventGroup)) {
            return false;
        }
        EventGroup other = (EventGroup)obj;
        if (this.groupId == null) {
            return other.groupId == null;
        }
        return this.groupId.equals(other.groupId);
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public Object getGroupId() {
        return this.groupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.events.isEmpty()) {
                return IteratorUtils.emptyIterator();
            }
            return IteratorUtils.arrayIterator((Object[])this.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent[] toArray() {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.events.isEmpty()) {
                return EMPTY_EVENTS_ARRAY;
            }
            return this.events.toArray(EMPTY_EVENTS_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(MuleEvent event) {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(MuleEvent event) {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            this.events.remove(event);
        }
    }

    public long getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            return this.events.size();
        }
    }

    public int expectedSize() {
        return this.expectedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            this.events.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        buf.append(ClassUtils.getSimpleName(this.getClass()));
        buf.append(" {");
        buf.append("id=").append(this.groupId);
        buf.append(", expected size=").append(this.expectedSize);
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            int currentSize = this.events.size();
            buf.append(", current events=").append(currentSize);
            if (currentSize > 0) {
                buf.append(" [");
                Iterator<MuleEvent> i = this.events.iterator();
                while (i.hasNext()) {
                    MuleEvent event = i.next();
                    buf.append(event.getMessage().getUniqueId());
                    if (!i.hasNext()) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public MuleMessageCollection toMessageCollection() {
        if (this.events.size() == 0) {
            return new DefaultMessageCollection(null);
        }
        DefaultMessageCollection col = new DefaultMessageCollection(this.events.get(0).getMuleContext());
        for (MuleEvent event : this.events) {
            col.addMessage(event.getMessage());
        }
        return col;
    }
}

