/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCollection;

public final class TransactionCoordination {
    protected static final Log logger = LogFactory.getLog(TransactionCoordination.class);
    private static final TransactionCoordination instance = new TransactionCoordination();
    private static final ThreadLocal<Transaction> transactions = new ThreadLocal();
    private int txCounter = 0;

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        return instance;
    }

    public Transaction getTransaction() {
        return transactions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindTransaction(Transaction transaction) throws TransactionException {
        TransactionCoordination transactionCoordination;
        Transaction oldTx = transactions.get();
        if (oldTx instanceof TransactionCollection && !((TransactionCollection)((Object)oldTx)).getTxCollection().isEmpty()) {
            return;
        }
        try {
            if (oldTx != null && !oldTx.equals(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionCannotUnbind());
            }
            Object var4_3 = null;
            transactions.set(null);
            transactionCoordination = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            transactions.set(null);
            TransactionCoordination transactionCoordination2 = this;
            synchronized (transactionCoordination2) {
                if (this.txCounter > 0) {
                    --this.txCounter;
                }
            }
            throw throwable;
        }
        synchronized (transactionCoordination) {
            if (this.txCounter > 0) {
                --this.txCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTransaction(Transaction transaction) throws TransactionException {
        Transaction oldTx = transactions.get();
        if (oldTx != null && !(oldTx instanceof TransactionCollection)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
        }
        if (oldTx instanceof TransactionCollection) {
            TransactionCollection txCollection = (TransactionCollection)((Object)oldTx);
            if (txCollection.getTxCollection().contains(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
            }
            return;
        }
        transactions.set(transaction);
        TransactionCoordination transactionCoordination = this;
        synchronized (transactionCoordination) {
            ++this.txCounter;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding new transaction (" + this.txCounter + ") " + transaction));
            }
        }
    }
}

