/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerChain
extends AbstractMessageAwareTransformer {
    private List<Transformer> transformers;

    public TransformerChain(List<Transformer> transformers) {
        if (transformers.size() < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = new LinkedList<Transformer>(transformers);
    }

    public TransformerChain(Transformer ... transformers) {
        this(Arrays.asList(transformers));
    }

    public TransformerChain(String name, List<Transformer> transformers) {
        this(transformers);
        this.name = name;
    }

    public TransformerChain(String name, Transformer ... transformers) {
        this(name, Arrays.asList(transformers));
    }

    @Override
    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        MuleMessage result = message;
        Object temp = message;
        Transformer lastTransformer2 = null;
        for (Transformer lastTransformer2 : this.transformers) {
            temp = lastTransformer2.transform(temp);
            if (temp instanceof MuleMessage) {
                result = (MuleMessage)temp;
                continue;
            }
            result.setPayload(temp);
        }
        if (lastTransformer2 != null && lastTransformer2.getReturnClass().equals(MuleMessage.class)) {
            return result;
        }
        return result.getPayload();
    }

    @Override
    public void initialise() throws InitialisationException {
        for (Transformer transformer : this.transformers) {
            transformer.initialise();
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        for (Transformer transformer : this.transformers) {
            transformer.setMuleContext(muleContext);
        }
    }

    @Override
    public void setEndpoint(ImmutableEndpoint endpoint) {
        super.setEndpoint(endpoint);
        for (Transformer transformer : this.transformers) {
            transformer.setEndpoint(endpoint);
        }
    }
}

