/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleSession;
import org.mule.NullSessionHandler;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.SecurityException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connector;
import org.mule.api.transport.InternalMessageListener;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.ExceptionHelper;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnectable;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public abstract class AbstractMessageReceiver
extends AbstractConnectable
implements MessageReceiver {
    protected Service service = null;
    private InternalMessageListener listener;
    protected String receiverKey = null;
    private EndpointURI endpointUri;
    protected boolean responseEndpoint = false;

    public AbstractMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(endpoint);
        this.setService(service);
        if (service.getResponseRouter() != null && service.getResponseRouter().getEndpoints().contains(endpoint)) {
            this.responseEndpoint = true;
        }
    }

    public final void initialise() throws InitialisationException {
        super.initialise();
        this.listener = new DefaultInternalMessageListener();
        this.endpointUri = this.endpoint.getEndpointURI();
        this.doInitialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        super.dispose();
        try {
            this.doDispose();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.disposed.set(true);
            throw throwable;
        }
        this.disposed.set(true);
    }

    protected void setExceptionDetails(MuleMessage message, Throwable exception) {
        String propName = ExceptionHelper.getErrorCodePropertyName(this.connector.getProtocol());
        if (propName != null) {
            String code = ExceptionHelper.getErrorMapping(this.connector.getProtocol(), exception.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting error code for: " + this.connector.getProtocol() + ", " + propName + "=" + code));
            }
            message.setProperty(propName, code);
        }
    }

    public Service getService() {
        return this.service;
    }

    public final MuleMessage routeMessage(MuleMessage message) throws MuleException {
        return this.routeMessage(message, this.endpoint.isSynchronous() || TransactionCoordination.getInstance().getTransaction() != null);
    }

    public final MuleMessage routeMessage(MuleMessage message, boolean synchronous) throws MuleException {
        Transaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, null);
    }

    public final MuleMessage routeMessage(MuleMessage message, Transaction trans, boolean synchronous) throws MuleException {
        return this.routeMessage(message, trans, synchronous, null);
    }

    public final MuleMessage routeMessage(MuleMessage message, OutputStream outputStream) throws MuleException {
        return this.routeMessage(message, this.endpoint.isSynchronous(), outputStream);
    }

    public final MuleMessage routeMessage(MuleMessage message, boolean synchronous, OutputStream outputStream) throws MuleException {
        Transaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, outputStream);
    }

    public final MuleMessage routeMessage(MuleMessage message, Transaction trans, boolean synchronous, OutputStream outputStream) throws MuleException {
        if (this.connector.isEnableMessageEvents()) {
            this.connector.fireNotification(new EndpointMessageNotification(message, this.endpoint, this.service.getName(), 801));
        }
        if (this.endpoint.isSynchronous()) {
            message.setBooleanProperty("MULE_REMOTE_SYNC", true);
        }
        if (message.getBooleanProperty("MULE_REMOTE_SYNC", false)) {
            synchronous = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message Received from: " + this.endpoint.getEndpointURI()));
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Message Payload: \n" + StringMessageUtils.truncate(StringMessageUtils.toString(message.getPayload()), 200, false)));
                this.logger.trace((Object)("Message detail: \n" + StringMessageUtils.headersToString(message)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(message)) {
            message = this.handleUnacceptedFilter(message);
            RequestContext.setEvent(new DefaultMuleEvent(message, this.endpoint, new DefaultMuleSession(message, new NullSessionHandler(), this.connector.getMuleContext()), synchronous));
            return message;
        }
        return this.listener.onMessage(message, trans, synchronous, outputStream);
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        String messageId = message.getUniqueId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message " + messageId + " failed to pass filter on endpoint: " + this.endpoint + ". Message is being ignored"));
        }
        return message;
    }

    public void setService(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("Service cannot be null");
        }
        this.service = service;
    }

    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    public InternalMessageListener getListener() {
        return this.listener;
    }

    public void setListener(InternalMessageListener listener) {
        this.listener = listener;
    }

    protected String getConnectEventId() {
        return this.connector.getName() + ".receiver (" + this.endpoint.getEndpointURI() + ")";
    }

    public void setReceiverKey(String receiverKey) {
        this.receiverKey = receiverKey;
    }

    public String getReceiverKey() {
        return this.receiverKey;
    }

    public InboundEndpoint getEndpoint() {
        return (InboundEndpoint)super.getEndpoint();
    }

    public void setEndpoint(InboundEndpoint endpoint) {
        super.setEndpoint(endpoint);
    }

    protected WorkManager getWorkManager() {
        try {
            return this.connector.getReceiverWorkManager("receiver");
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", receiverKey=").append(this.receiverKey);
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append('}');
        return sb.toString();
    }

    private class DefaultInternalMessageListener
    implements InternalMessageListener {
        private DefaultInternalMessageListener() {
        }

        public MuleMessage onMessage(MuleMessage message, Transaction trans, boolean synchronous, OutputStream outputStream) throws MuleException {
            MessageAdapter resultMessage = null;
            ResponseOutputStream ros = null;
            if (outputStream != null) {
                ros = outputStream instanceof ResponseOutputStream ? (ResponseOutputStream)outputStream : new ResponseOutputStream(outputStream);
            }
            DefaultMuleSession session = new DefaultMuleSession(message, AbstractMessageReceiver.this.connector.getSessionHandler(), AbstractMessageReceiver.this.service, AbstractMessageReceiver.this.connector.getMuleContext());
            MuleEvent muleEvent = new DefaultMuleEvent(message, AbstractMessageReceiver.this.endpoint, (MuleSession)session, synchronous, ros);
            muleEvent = OptimizedRequestContext.unsafeSetEvent(muleEvent);
            boolean authorised = false;
            if (AbstractMessageReceiver.this.endpoint.getSecurityFilter() != null) {
                try {
                    AbstractMessageReceiver.this.endpoint.getSecurityFilter().authenticate(muleEvent);
                    authorised = true;
                }
                catch (SecurityException e) {
                    AbstractMessageReceiver.this.logger.warn((Object)("Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                    AbstractMessageReceiver.this.connector.fireNotification(new SecurityNotification(e, 401));
                    AbstractMessageReceiver.this.handleException(e);
                    resultMessage = RequestContext.getEvent().getMessage();
                    resultMessage.setPayload(e.getLocalizedMessage());
                }
            } else {
                authorised = true;
            }
            if (authorised) {
                if (AbstractMessageReceiver.this.responseEndpoint) {
                    muleEvent.transformMessage();
                    AbstractMessageReceiver.this.service.getResponseRouter().route(muleEvent);
                    return null;
                }
                resultMessage = AbstractMessageReceiver.this.service.getInboundRouter().route(muleEvent);
            }
            if (resultMessage != null) {
                if (resultMessage.getExceptionPayload() != null) {
                    AbstractMessageReceiver.this.setExceptionDetails((MuleMessage)resultMessage, resultMessage.getExceptionPayload().getException());
                }
                resultMessage.applyTransformers(AbstractMessageReceiver.this.endpoint.getResponseTransformers());
            }
            return resultMessage;
        }
    }
}

