/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentSkipListMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.Map;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.store.AbstractMonitoredObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryObjectStore
extends AbstractMonitoredObjectStore {
    protected ConcurrentSkipListMap store = new ConcurrentSkipListMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsObject(String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("id").toString());
        }
        ConcurrentSkipListMap concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            return this.store.values().contains(new StoredObject(id, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(String id, Object item) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("id").toString());
        }
        StoredObject obj = new StoredObject(id, item);
        ConcurrentSkipListMap concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            if (this.store.values().contains(obj)) {
                return false;
            }
            boolean written = false;
            while (!written) {
                Long key = Utils.nanoTime();
                written = this.store.put((Object)key, (Object)obj) == null;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object retrieveObject(String id) throws Exception {
        ConcurrentSkipListMap concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry(id);
            if (entry != null) {
                StoredObject object = (StoredObject)entry.getValue();
                return object.getItem();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeObject(String id) throws Exception {
        ConcurrentSkipListMap concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry(id);
            if (entry != null) {
                Object removedObject = this.store.remove(entry.getKey());
                boolean bl = removedObject != null;
                return bl;
            }
        }
        return true;
    }

    private Map.Entry<?, ?> findEntry(String id) {
        for (Map.Entry entry : this.store.entrySet()) {
            StoredObject object = (StoredObject)entry.getValue();
            if (!object.getId().equals(id)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public final void expire() {
        int currentSize = this.store.size();
        currentSize = this.trimToMaxSize(currentSize);
        if (this.entryTTL > 0 && currentSize != 0) {
            Long oldestKey;
            long oldestKeyValue;
            Map.Entry oldestEntry;
            long now = Utils.nanoTime();
            int expiredEntries = 0;
            while ((oldestEntry = this.store.firstEntry()) != null && TimeUnit.NANOSECONDS.toMillis(now - (oldestKeyValue = (oldestKey = (Long)oldestEntry.getKey()).longValue())) >= (long)this.entryTTL) {
                this.store.remove((Object)oldestKey);
                ++expiredEntries;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + expiredEntries + " old entries"));
            }
        }
    }

    private int trimToMaxSize(int currentSize) {
        if (this.maxEntries < 0) {
            return currentSize;
        }
        int excess = currentSize - this.maxEntries;
        if (excess > 0) {
            while (currentSize > this.maxEntries) {
                this.store.pollFirstEntry();
                --currentSize;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + excess + " excess entries"));
            }
        }
        return currentSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.store;
    }

    protected static class StoredObject {
        private String id;
        private Object item;

        public StoredObject(String id, Object item) {
            this.id = id;
            this.item = item;
        }

        public String getId() {
            return this.id;
        }

        public Object getItem() {
            return this.item;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredObject that = (StoredObject)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("StoredObject");
            sb.append("{id='").append(this.id).append('\'');
            sb.append(", item=").append(this.item);
            sb.append('}');
            return sb.toString();
        }
    }
}

