/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.lifecycle.GenericLifecycleManager;
import org.mule.lifecycle.phases.MuleContextDisposePhase;
import org.mule.lifecycle.phases.MuleContextInitialisePhase;
import org.mule.lifecycle.phases.MuleContextStartPhase;
import org.mule.lifecycle.phases.MuleContextStopPhase;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.work.MuleWorkManager;

public class DefaultMuleContextBuilderTestCase
extends AbstractMuleTestCase {
    public void testBuildMuleContextDefault() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        MuleContext muleContext = builder.buildMuleContext();
        DefaultMuleContextBuilderTestCase.assertNotNull((Object)muleContext);
        DefaultMuleContextBuilderTestCase.assertEquals(DefaultMuleConfiguration.class, muleContext.getConfiguration().getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(GenericLifecycleManager.class, muleContext.getLifecycleManager().getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MuleContextInitialisePhase.class, muleContext.getLifecycleManager().getLifecycles().toArray()[0].getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MuleContextStartPhase.class, muleContext.getLifecycleManager().getLifecycles().toArray()[1].getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MuleContextStopPhase.class, muleContext.getLifecycleManager().getLifecycles().toArray()[2].getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MuleContextDisposePhase.class, muleContext.getLifecycleManager().getLifecycles().toArray()[3].getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(ServerNotificationManager.class, muleContext.getNotificationManager().getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MuleWorkManager.class, muleContext.getWorkManager().getClass());
    }

    public void testBuildMuleContextCustom() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        builder.setMuleConfiguration((MuleConfiguration)new MyMuleConfiguration());
        builder.setLifecycleManager((LifecycleManager)new MyLifeCycleManager());
        builder.setNotificationManager((ServerNotificationManager)new MyServerNotificationManager());
        builder.setWorkManager((WorkManager)new MyWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, "test"));
        MuleContext muleContext = builder.buildMuleContext();
        DefaultMuleContextBuilderTestCase.assertNotNull((Object)muleContext);
        DefaultMuleContextBuilderTestCase.assertEquals(MyMuleConfiguration.class, muleContext.getConfiguration().getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MyLifeCycleManager.class, muleContext.getLifecycleManager().getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MyServerNotificationManager.class, muleContext.getNotificationManager().getClass());
        DefaultMuleContextBuilderTestCase.assertEquals(MyWorkManager.class, muleContext.getWorkManager().getClass());
    }

    protected MuleContext createMuleContext() throws Exception {
        return null;
    }

    static class MyWorkManager
    extends MuleWorkManager {
        public MyWorkManager(ThreadingProfile profile, String name) {
            super(profile, name, 5000);
        }
    }

    static class MyServerNotificationManager
    extends ServerNotificationManager {
        MyServerNotificationManager() {
        }
    }

    static class MyMuleConfiguration
    extends DefaultMuleConfiguration {
        MyMuleConfiguration() {
        }
    }

    static class MyLifeCycleManager
    extends GenericLifecycleManager {
        MyLifeCycleManager() {
        }
    }
}

