/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.simple.ByteArrayToObject;
import org.mule.transformer.simple.ObjectToByteArray;

public class MuleMessageAttachmentSerializationTestCase
extends AbstractMuleTestCase {
    public void testAttachmentPersistence() throws Exception {
        ObjectToByteArray transformer = new ObjectToByteArray();
        transformer.setAcceptMuleMessage(true);
        MuleEvent event = RequestContext.setEvent((MuleEvent)MuleMessageAttachmentSerializationTestCase.getTestEvent("Mmm... attachments!"));
        MuleMessage msg = event.getMessage();
        msg.addAttachment("test-attachment", new DataHandler((DataSource)new StringDataSource("attachment")));
        Object serialized = transformer.transform((Object)msg);
        MuleMessageAttachmentSerializationTestCase.assertNotNull((Object)serialized);
        MuleMessage deserialized = (MuleMessage)new ByteArrayToObject().transform(serialized);
        MuleMessageAttachmentSerializationTestCase.assertNotNull((Object)deserialized);
        MuleMessageAttachmentSerializationTestCase.assertEquals((String)deserialized.getUniqueId(), (String)msg.getUniqueId());
        MuleMessageAttachmentSerializationTestCase.assertEquals((Object)deserialized.getPayload(), (Object)msg.getPayload());
        MuleMessageAttachmentSerializationTestCase.assertEquals((Object)deserialized.getAttachmentNames(), (Object)msg.getAttachmentNames());
    }

    protected static class StringDataSource
    implements DataSource {
        protected String content;

        public StringDataSource(String payload) {
            this.content = payload;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes());
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
        }

        public String getContentType() {
            return "text/plain";
        }

        public String getName() {
            return "StringDataSource";
        }
    }
}

