/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import org.mule.api.component.LifecycleAdapter;
import org.mule.api.object.ObjectFactory;
import org.mule.component.AbstractComponentTestCase;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.DefaultLifecycleAdapter;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;

public class DefaultJavaComponentTestCase
extends AbstractComponentTestCase {
    public void testComponentCreation() throws Exception {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(Orange.class);
        objectFactory.setObjectClass(Orange.class);
        objectFactory.initialise();
        DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)objectFactory);
        DefaultJavaComponentTestCase.assertNotNull((Object)component.getObjectFactory());
        DefaultJavaComponentTestCase.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        DefaultJavaComponentTestCase.assertEquals(Orange.class, (Object)component.getObjectFactory().getObjectClass());
        DefaultJavaComponentTestCase.assertEquals(Orange.class, (Object)component.getObjectType());
    }

    public void testLifecycle() throws Exception {
        DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)new PrototypeObjectFactory(Orange.class));
        component.setService(DefaultJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        DefaultJavaComponentTestCase.assertNotSame((Object)component.borrowComponentLifecycleAdaptor(), (Object)component.borrowComponentLifecycleAdaptor());
        Object obj = component.getObjectFactory().getInstance();
        DefaultJavaComponentTestCase.assertNotNull((Object)obj);
        component.stop();
        component.start();
        DefaultJavaComponentTestCase.assertNotSame(((DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject.get(), ((DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject.get());
    }

    public void testComponentDisposal() throws Exception {
        DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)new PrototypeObjectFactory(WaterMelon.class));
        component.setService(DefaultJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        DefaultLifecycleAdapter lifecycleAdapter = (DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        component.returnComponentLifecycleAdaptor((LifecycleAdapter)lifecycleAdapter);
        component.dispose();
        DefaultJavaComponentTestCase.assertNull(lifecycleAdapter.componentObject.get());
    }
}

