/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import junit.framework.Assert;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.object.ObjectFactory;
import org.mule.component.AbstractComponentTestCase;
import org.mule.component.DefaultLifecycleAdapter;
import org.mule.component.PooledJavaComponent;
import org.mule.config.PoolingProfile;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.services.UniqueComponent;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;
import org.mule.util.ExceptionUtils;

public class PooledJavaComponentTestCase
extends AbstractComponentTestCase {
    public static final byte MAX_ACTIVE = 3;
    public static final long MAX_WAIT = 1500L;

    protected PoolingProfile getDefaultPoolingProfile() {
        PoolingProfile pp = new PoolingProfile();
        pp.setExhaustedAction(0);
        pp.setMaxActive(3);
        pp.setMaxWait(1500L);
        pp.setInitialisationPolicy(0);
        return pp;
    }

    protected PrototypeObjectFactory getObjectFactory() {
        return new PrototypeObjectFactory(Orange.class);
    }

    public void testComponentCreation() throws Exception {
        PrototypeObjectFactory objectFactory = this.getObjectFactory();
        objectFactory.setObjectClass(Orange.class);
        objectFactory.initialise();
        PoolingProfile pp = this.getDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)objectFactory, pp);
        component.setMuleContext(muleContext);
        PooledJavaComponentTestCase.assertNotNull((Object)component.getObjectFactory());
        PooledJavaComponentTestCase.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        PooledJavaComponentTestCase.assertEquals(Orange.class, (Object)component.getObjectFactory().getObjectClass());
        PooledJavaComponentTestCase.assertEquals(Orange.class, (Object)component.getObjectType());
        PooledJavaComponentTestCase.assertNotNull((Object)component.getPoolingProfile());
        PooledJavaComponentTestCase.assertEquals((Object)pp, (Object)component.getPoolingProfile());
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.getPoolingProfile().getExhaustedAction());
    }

    public void testPoolCreation() throws Exception {
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), this.getDefaultPoolingProfile());
        PooledJavaComponentTestCase.assertNull((Object)component.lifecycleAdapterPool);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        PooledJavaComponentTestCase.assertNull((Object)component.lifecycleAdapterPool);
        component.start();
        PooledJavaComponentTestCase.assertNotNull((Object)component.lifecycleAdapterPool);
        component.stop();
        PooledJavaComponentTestCase.assertNull((Object)component.lifecycleAdapterPool);
    }

    public void testLifecycle() throws Exception {
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), this.getDefaultPoolingProfile());
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        PooledJavaComponentTestCase.assertNotSame((Object)component.borrowComponentLifecycleAdaptor(), (Object)component.borrowComponentLifecycleAdaptor());
        component.stop();
        component.start();
        PooledJavaComponentTestCase.assertNotSame(((DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject.get(), ((DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject.get());
    }

    public void testCreatePool() throws Exception {
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), this.getDefaultPoolingProfile());
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        PooledJavaComponentTestCase.assertEquals((int)1, (int)component.lifecycleAdapterPool.getNumActive());
        component.returnComponentLifecycleAdaptor(borrowed);
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        PooledJavaComponentTestCase.assertEquals((int)1, (int)component.lifecycleAdapterPool.getNumActive());
        LifecycleAdapter borrowed2 = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed2);
        PooledJavaComponentTestCase.assertEquals((int)2, (int)component.lifecycleAdapterPool.getNumActive());
    }

    public void testFailOnExhaust() throws Exception {
        PoolingProfile pp = this.getDefaultPoolingProfile();
        pp.setExhaustedAction(1);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), pp);
        component.setMuleContext(muleContext);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        LifecycleAdapter borrowed = null;
        for (int i = 0; i < 3; ++i) {
            borrowed = component.borrowComponentLifecycleAdaptor();
            PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
            PooledJavaComponentTestCase.assertEquals((int)component.lifecycleAdapterPool.getNumActive(), (int)(i + 1));
        }
        try {
            borrowed = component.borrowComponentLifecycleAdaptor();
            PooledJavaComponentTestCase.fail((String)"Should throw an Exception");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testBlockExpiryOnExhaust() throws Exception {
        PoolingProfile pp = this.getDefaultPoolingProfile();
        pp.setExhaustedAction(1);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), pp);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        LifecycleAdapter borrowed = null;
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        PooledJavaComponentTestCase.assertEquals((int)3, (int)component.lifecycleAdapterPool.getNumActive());
        try {
            borrowed = component.borrowComponentLifecycleAdaptor();
            PooledJavaComponentTestCase.fail((String)"Should throw an Exception");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testBlockOnExhaust() throws Exception {
        PoolingProfile pp = this.getDefaultPoolingProfile();
        pp.setExhaustedAction(1);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), pp);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        LifecycleAdapter borrowed = null;
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        borrowed = component.borrowComponentLifecycleAdaptor();
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertEquals((int)2, (int)component.lifecycleAdapterPool.getNumActive());
        long borrowerWait = 500L;
        Borrower borrower = new Borrower(component, borrowerWait);
        borrower.start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
    }

    public void testGrowOnExhaust() throws Exception {
        PoolingProfile pp = this.getDefaultPoolingProfile();
        pp.setExhaustedAction(2);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), pp);
        component.setMuleContext(muleContext);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        borrowed = component.borrowComponentLifecycleAdaptor();
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertEquals((int)3, (int)component.lifecycleAdapterPool.getNumActive());
        borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertNotNull((Object)borrowed);
        PooledJavaComponentTestCase.assertEquals((int)4, (int)component.lifecycleAdapterPool.getNumActive());
    }

    public void testClearPool() throws Exception {
        PoolingProfile pp = this.getDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)this.getObjectFactory(), pp);
        component.setMuleContext(muleContext);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        LifecycleAdapter borrowed = component.borrowComponentLifecycleAdaptor();
        PooledJavaComponentTestCase.assertEquals((int)1, (int)component.lifecycleAdapterPool.getNumActive());
        component.returnComponentLifecycleAdaptor(borrowed);
        component.stop();
        component.start();
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
    }

    public void testObjectUniqueness() throws Exception {
        PoolingProfile pp = this.getDefaultPoolingProfile();
        pp.setExhaustedAction(0);
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)new PrototypeObjectFactory(UniqueComponent.class), pp);
        component.setMuleContext(muleContext);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        PooledJavaComponentTestCase.assertEquals((int)0, (int)component.lifecycleAdapterPool.getNumActive());
        Object obj = ((DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject.get();
        PooledJavaComponentTestCase.assertNotNull(obj);
        PooledJavaComponentTestCase.assertTrue((String)"Object should be of type UniqueComponent", (boolean)(obj instanceof UniqueComponent));
        String id1 = ((UniqueComponent)obj).getId();
        PooledJavaComponentTestCase.assertNotNull((Object)id1);
        obj = ((DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject.get();
        PooledJavaComponentTestCase.assertNotNull(obj);
        PooledJavaComponentTestCase.assertTrue((String)"Object should be of type UniqueComponent", (boolean)(obj instanceof UniqueComponent));
        String id2 = ((UniqueComponent)obj).getId();
        PooledJavaComponentTestCase.assertNotNull((Object)id2);
        obj = ((DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject.get();
        PooledJavaComponentTestCase.assertNotNull(obj);
        PooledJavaComponentTestCase.assertTrue((String)"Object should be of type UniqueComponent", (boolean)(obj instanceof UniqueComponent));
        String id3 = ((UniqueComponent)obj).getId();
        PooledJavaComponentTestCase.assertNotNull((Object)id3);
        PooledJavaComponentTestCase.assertFalse((String)("Service IDs " + id1 + " and " + id2 + " should be different"), (boolean)id1.equals(id2));
        PooledJavaComponentTestCase.assertFalse((String)("Service IDs " + id2 + " and " + id3 + " should be different"), (boolean)id2.equals(id3));
    }

    public void testDisposingFactoryDisposesObject() throws Exception {
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)new PrototypeObjectFactory(WaterMelon.class), this.getDefaultPoolingProfile());
        component.setMuleContext(muleContext);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        DefaultLifecycleAdapter lifecycleAdapter = (DefaultLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        component.returnComponentLifecycleAdaptor((LifecycleAdapter)lifecycleAdapter);
        component.dispose();
        PooledJavaComponentTestCase.assertNull(lifecycleAdapter.componentObject.get());
    }

    public void testLifeCycleMethods() throws Exception {
        PooledJavaComponent component = new PooledJavaComponent((ObjectFactory)new PrototypeObjectFactory(WaterMelon.class), this.getDefaultPoolingProfile());
        component.setMuleContext(muleContext);
        component.setService(PooledJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        Object obj = component.lifecycleAdapterPool.getObjectFactory().getInstance();
        PooledJavaComponentTestCase.assertNotNull((Object)obj);
    }

    private class Borrower
    extends Thread {
        private PooledJavaComponent component;
        private long time;

        public Borrower(PooledJavaComponent component, long time) {
            super("Borrower");
            if (component == null) {
                throw new IllegalArgumentException("Pool cannot be null");
            }
            this.component = component;
            if (time < 500L) {
                time = 500L;
            }
            this.time = time;
        }

        public void run() {
            try {
                LifecycleAdapter object = this.component.borrowComponentLifecycleAdaptor();
                try {
                    Borrower.sleep(this.time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.component.returnComponentLifecycleAdaptor(object);
            }
            catch (Exception e) {
                Assert.fail((String)("Borrower thread failed:\n" + ExceptionUtils.getStackTrace((Throwable)e)));
            }
        }
    }
}

