/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestInboundTransformer;
import org.mule.tck.testmodels.mule.TestOutboundTransformer;
import org.mule.tck.testmodels.mule.TestResponseTransformer;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.util.ObjectNameHelper;

public class EndpointURIEndpointBuilderTestCase
extends AbstractMuleTestCase {
    public void testBuildInboundEndpoint() throws Exception {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        InboundEndpoint ep = endpointBuilder.buildInboundEndpoint();
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep instanceof InboundEndpoint));
        EndpointURIEndpointBuilderTestCase.assertFalse((boolean)(ep instanceof OutboundEndpoint));
        EndpointURIEndpointBuilderTestCase.assertNotNull((Object)ep.getTransformers());
        EndpointURIEndpointBuilderTestCase.assertEquals((int)1, (int)ep.getTransformers().size());
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getTransformers().get(0) instanceof TestInboundTransformer));
        EndpointURIEndpointBuilderTestCase.assertNotNull((Object)ep.getResponseTransformers());
        EndpointURIEndpointBuilderTestCase.assertEquals((int)1, (int)ep.getResponseTransformers().size());
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getResponseTransformers().get(0) instanceof TestResponseTransformer));
        this.testDefaultCommonEndpointAttributes((ImmutableEndpoint)ep);
    }

    public void testBuildOutboundEndpoint() throws MuleException {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        try {
            OutboundEndpoint ep = endpointBuilder.buildOutboundEndpoint();
            EndpointURIEndpointBuilderTestCase.assertFalse((boolean)(ep instanceof InboundEndpoint));
            EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep instanceof OutboundEndpoint));
            EndpointURIEndpointBuilderTestCase.assertTrue((ep.getTransformers() != null ? 1 : 0) != 0);
            EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getTransformers().get(0) instanceof TestOutboundTransformer));
            EndpointURIEndpointBuilderTestCase.assertTrue((boolean)ep.getResponseTransformers().isEmpty());
            this.testDefaultCommonEndpointAttributes((ImmutableEndpoint)ep);
        }
        catch (Exception e) {
            EndpointURIEndpointBuilderTestCase.fail((String)("Unexpected exception: " + e.getStackTrace()));
        }
    }

    protected void testDefaultCommonEndpointAttributes(ImmutableEndpoint ep) {
        EndpointURIEndpointBuilderTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointURIEndpointBuilderTestCase.assertEquals((int)muleContext.getConfiguration().getDefaultResponseTimeout(), (int)ep.getResponseTimeout());
        EndpointURIEndpointBuilderTestCase.assertEquals((boolean)muleContext.getConfiguration().isDefaultSynchronousEndpoints(), (boolean)ep.isSynchronous());
        EndpointURIEndpointBuilderTestCase.assertTrue((String)("ep.getRetryPolicyTemplate() = " + ep.getRetryPolicyTemplate().getClass()), (boolean)(ep.getRetryPolicyTemplate() instanceof NoRetryPolicyTemplate));
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getTransactionConfig() instanceof MuleTransactionConfig));
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getTransactionConfig() instanceof MuleTransactionConfig));
        EndpointURIEndpointBuilderTestCase.assertEquals(null, (Object)ep.getSecurityFilter());
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getConnector() instanceof TestConnector));
        EndpointURIEndpointBuilderTestCase.assertEquals((String)new ObjectNameHelper(muleContext).getEndpointName(ep.getEndpointURI()), (String)ep.getName());
        EndpointURIEndpointBuilderTestCase.assertFalse((boolean)ep.isDeleteUnacceptedMessages());
        EndpointURIEndpointBuilderTestCase.assertEquals((String)muleContext.getConfiguration().getDefaultEncoding(), (String)ep.getEncoding());
        EndpointURIEndpointBuilderTestCase.assertEquals(null, (Object)ep.getFilter());
        EndpointURIEndpointBuilderTestCase.assertEquals((String)"started", (String)ep.getInitialState());
    }

    public void testHasSetEncodingMethod() throws EndpointException, SecurityException, NoSuchMethodException {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        EndpointURIEndpointBuilderTestCase.assertNotNull((Object)endpointBuilder.getClass().getMethod("setEncoding", String.class));
    }
}

