/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptor;

import java.util.ArrayList;
import junit.framework.Assert;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.interceptor.Invocation;
import org.mule.api.service.Service;
import org.mule.component.AbstractComponent;
import org.mule.interceptor.EnvelopeInterceptor;
import org.mule.interceptor.InterceptorStack;
import org.mule.tck.AbstractMuleTestCase;

public class InterceptorTestCase
extends AbstractMuleTestCase {
    private final String BEFORE = "Before";
    private final String AFTER = "After";
    private final String COMPONENT = "component";
    private final String INTERCEPTOR_ONE = "inteceptor1";
    private final String INTERCEPTOR_TWO = "inteceptor2";
    private final String INTERCEPTOR_THREE = "inteceptor3";
    private final String SINGLE_INTERCEPTOR_RESULT = "inteceptor1Beforecomponentinteceptor1After";
    private final String MULTIPLE_INTERCEPTOR_RESULT = "inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After";

    public void testSingleInterceptor() throws Exception {
        Service service = InterceptorTestCase.getTestService();
        TestComponent component = new TestComponent();
        service.setComponent((Component)component);
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        component.setInterceptors(interceptors);
        service.start();
        MuleMessage result = service.sendEvent(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforecomponentinteceptor1After", (String)result.getPayloadAsString());
    }

    public void testMultipleInterceptor() throws Exception {
        Service service = InterceptorTestCase.getTestService();
        TestComponent component = new TestComponent();
        service.setComponent((Component)component);
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        component.setInterceptors(interceptors);
        service.start();
        MuleMessage result = service.sendEvent(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (String)result.getPayloadAsString());
    }

    public void testSingleInterceptorStack() throws Exception {
        Service service = InterceptorTestCase.getTestService();
        TestComponent component = new TestComponent();
        service.setComponent((Component)component);
        ArrayList<InterceptorStack> interceptors = new ArrayList<InterceptorStack>();
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.start();
        MuleMessage result = service.sendEvent(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforecomponentinteceptor1After", (String)result.getPayloadAsString());
    }

    public void testMultipleInterceptorStack() throws Exception {
        Service service = InterceptorTestCase.getTestService();
        TestComponent component = new TestComponent();
        service.setComponent((Component)component);
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.start();
        MuleMessage result = service.sendEvent(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (String)result.getPayloadAsString());
    }

    public void testMultipleInterceptorStack2() throws Exception {
        Service service = InterceptorTestCase.getTestService();
        TestComponent component = new TestComponent();
        service.setComponent((Component)component);
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.start();
        MuleMessage result = service.sendEvent(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforeinteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1Afterinteceptor3Afterinteceptor2Afterinteceptor1After", (String)result.getPayloadAsString());
    }

    class TestComponent
    extends AbstractComponent {
        TestComponent() {
        }

        protected Object doInvoke(MuleEvent event) throws Exception {
            return event.getMessageAsString() + "component";
        }
    }

    class TestInterceptor
    extends EnvelopeInterceptor {
        private String name;

        public TestInterceptor(String name) {
            this.name = name;
        }

        public void after(Invocation invocation) {
            try {
                invocation.setMessage((MuleMessage)new DefaultMuleMessage((Object)(invocation.getMessage().getPayloadAsString() + this.name + "After"), muleContext));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }

        public void before(Invocation invocation) {
            try {
                invocation.setMessage((MuleMessage)new DefaultMuleMessage((Object)(invocation.getMessage().getPayloadAsString() + this.name + "Before"), muleContext));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

