/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.tck.AbstractMuleTestCase;

public class MessagePropertyFilterTestCase
extends AbstractMuleTestCase {
    public void testMessagePropertyFilter() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithNot() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        message.setProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setProperty("foo", (Object)"car");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithNotNull() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.removeProperty("foo");
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setProperty("foo", (Object)"car");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithCaseSensitivity() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=Bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        filter.setCaseSensitive(false);
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithWildcard() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=B*");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        filter.setCaseSensitive(false);
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        filter.setPattern("foo=*a*");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterDodgyValues() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter();
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept(null));
        filter = new MessagePropertyFilter("foo = bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        filter.setCaseSensitive(false);
        filter = new MessagePropertyFilter("foo2 =null");
        message.removeProperty("foo2");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        filter = new MessagePropertyFilter("foo2 =");
        message.setProperty("foo2", (Object)"");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        message.removeProperty("foo2");
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
    }

    public void testMessagePropertyFilterPropertyExists() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setProperty("foo", (Object)"car");
        MessagePropertyFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }
}

