/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.tck.TestCaseWatchdogTimeoutHandler;

public class TestCaseWatchdog
extends Thread {
    protected static final AtomicInteger threadNumber = new AtomicInteger(0);
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final long delay;
    protected final TimeUnit unit;
    protected final TestCaseWatchdogTimeoutHandler handler;
    protected volatile boolean timedOut = false;

    public TestCaseWatchdog(long delay, TimeUnit unit, TestCaseWatchdogTimeoutHandler timeoutHandler) {
        super("WatchdogThread-" + threadNumber.getAndIncrement());
        this.setDaemon(true);
        this.delay = delay;
        this.unit = unit;
        this.handler = timeoutHandler;
    }

    public void run() {
        block4: {
            long millisToWait = this.unit.toMillis(this.delay);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Starting with " + millisToWait + "ms timeout."));
            }
            try {
                Thread.sleep(millisToWait);
                this.timedOut = true;
                if (this.handler != null) {
                    this.handler.handleTimeout(this.delay, this.unit);
                }
            }
            catch (InterruptedException interrupted) {
                if (!this.log.isDebugEnabled()) break block4;
                this.log.debug((Object)"Watchdog stopped.");
            }
        }
    }

    public void cancel() {
        this.interrupt();
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }
}

