/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.io.InputStream;
import java.util.Arrays;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.InvalidSatsuma;
import org.mule.util.IOUtils;

public abstract class AbstractTransformerTestCase
extends AbstractMuleTestCase {
    protected void doSetUp() throws Exception {
        RequestContext.setEvent((MuleEvent)AbstractTransformerTestCase.getTestEvent("test"));
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
    }

    protected String normalizeString(String rawString) {
        rawString = rawString.replaceAll("\r", "");
        rawString = rawString.replaceAll("\n", "");
        return rawString.replaceAll("\t", "");
    }

    public void testTransform() throws Exception {
        Transformer trans = this.getTransformer();
        Object result = trans.transform(this.getTestData());
        AbstractTransformerTestCase.assertNotNull((Object)result);
        Object expectedResult = this.getResultData();
        AbstractTransformerTestCase.assertNotNull((Object)expectedResult);
        AbstractTransformerTestCase.assertTrue((boolean)this.compareResults(expectedResult, result));
    }

    public void testRoundtripTransform() throws Exception {
        Transformer roundTripTransformer = this.getRoundTripTransformer();
        if (roundTripTransformer != null) {
            Object result = roundTripTransformer.transform(this.getResultData());
            AbstractTransformerTestCase.assertNotNull((Object)result);
            AbstractTransformerTestCase.assertTrue((boolean)this.compareRoundtripResults(this.getTestData(), result));
        }
    }

    public void testBadReturnType() throws Exception {
        this.doTestBadReturnType(this.getTransformer(), this.getTestData());
    }

    public void testRoundtripBadReturnType() throws Exception {
        if (this.getRoundTripTransformer() != null) {
            this.doTestBadReturnType(this.getRoundTripTransformer(), this.getResultData());
        }
    }

    public void testRoundTrip() throws Exception {
        if (this.getRoundTripTransformer() != null) {
            Transformer trans = this.getTransformer();
            Transformer trans2 = this.getRoundTripTransformer();
            DefaultMuleMessage message = new DefaultMuleMessage(this.getTestData(), muleContext);
            message.applyTransformers(Arrays.asList(trans, trans2));
            Object result = message.getPayload();
            this.compareRoundtripResults(this.getTestData(), result);
        }
    }

    public void doTestBadReturnType(Transformer tran, Object src) throws Exception {
        tran.setReturnClass(InvalidSatsuma.class);
        try {
            tran.transform(src);
            AbstractTransformerTestCase.fail((String)"Should throw exception for bad return type");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    protected void doTestClone(Transformer original, Transformer clone) throws Exception {
        AbstractTransformerTestCase.assertNotSame((Object)original, (Object)clone);
    }

    public abstract Transformer getTransformer() throws Exception;

    public abstract Transformer getRoundTripTransformer() throws Exception;

    public abstract Object getTestData();

    public abstract Object getResultData();

    public boolean compareResults(Object expected, Object result) {
        if (expected == null && result == null) {
            return true;
        }
        if (expected == null || result == null) {
            return false;
        }
        if (expected instanceof Object[] && result instanceof Object[]) {
            return Arrays.equals((Object[])expected, (Object[])result);
        }
        if (expected instanceof byte[] && result instanceof byte[]) {
            return Arrays.equals((byte[])expected, (byte[])result);
        }
        if (expected instanceof InputStream) {
            expected = IOUtils.toString((InputStream)((InputStream)expected));
        }
        if (expected instanceof String && result instanceof String) {
            expected = this.normalizeString((String)expected);
            result = this.normalizeString((String)result);
        }
        return expected.equals(result);
    }

    public boolean compareRoundtripResults(Object expected, Object result) {
        return this.compareResults(expected, result);
    }
}

