/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.transport.MessageAdapter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.DefaultMessageAdapter;

public abstract class AbstractMessageAdapterSerializationTestCase
extends AbstractMuleTestCase {
    protected static final String PAYLOAD = "Hello Mule";
    protected static final String STRING_PROPERTY_KEY = "string";
    protected static final String STRING_PROPERTY_VALUE = "hello";

    public void testMessageAdapterSerialization() throws Exception {
        MessageAdapter messageAdapter = this.createAndCheckMessageAdapter();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)messageAdapter, muleContext);
        byte[] serializedMessage = SerializationUtils.serialize((Serializable)muleMessage);
        DefaultMuleMessage readMessage = (DefaultMuleMessage)SerializationUtils.deserialize((byte[])serializedMessage);
        AbstractMessageAdapterSerializationTestCase.assertNotNull((Object)readMessage.getAdapter());
        AbstractMessageAdapterSerializationTestCase.assertTrue((boolean)(readMessage.getAdapter() instanceof DefaultMessageAdapter));
        DefaultMessageAdapter readAdapter = (DefaultMessageAdapter)readMessage.getAdapter();
        byte[] payload = (byte[])readAdapter.getPayload();
        AbstractMessageAdapterSerializationTestCase.assertEquals((String)PAYLOAD, (String)new String(payload));
        AbstractMessageAdapterSerializationTestCase.assertEquals((Object)STRING_PROPERTY_VALUE, (Object)readAdapter.getProperty(STRING_PROPERTY_KEY));
        this.doAdditionalAssertions(readAdapter);
    }

    private MessageAdapter createAndCheckMessageAdapter() throws Exception {
        MessageAdapter messageAdapter = this.createMessageAdapter();
        AbstractMessageAdapterSerializationTestCase.assertEquals((Object)STRING_PROPERTY_VALUE, (Object)messageAdapter.getProperty(STRING_PROPERTY_KEY));
        return messageAdapter;
    }

    protected abstract MessageAdapter createMessageAdapter() throws Exception;

    protected void doAdditionalAssertions(DefaultMessageAdapter messageAdapter) {
    }
}

