/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.OrangeInterface;
import org.mule.util.BeanUtils;

public class BeanUtilsTestCase
extends AbstractMuleTestCase {
    public void testBeanPropertiesOnAProxy() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brand", "Juicy!");
        map.put("radius", "2.32");
        map.put("segments", "22");
        OrangeInterface o = (OrangeInterface)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{OrangeInterface.class}, (InvocationHandler)new OrangeInvocationHandler(new Orange()));
        BeanUtils.populateWithoutFail((Object)o, map, (boolean)true);
        BeanUtilsTestCase.assertNotNull((Object)o);
        BeanUtilsTestCase.assertEquals((String)"Juicy!", (String)o.getBrand());
        BeanUtilsTestCase.assertEquals((Object)new Double(2.32), (Object)o.getRadius());
        BeanUtilsTestCase.assertEquals((Object)new Integer(22), (Object)o.getSegments());
    }

    public void testBeanPropertiesWithoutFail() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brand", "Juicy!");
        map.put("radius", "2.32");
        map.put("segments", "22");
        map.put("trombones", "3");
        Orange o = new Orange();
        BeanUtils.populateWithoutFail((Object)o, map, (boolean)true);
        BeanUtilsTestCase.assertNotNull((Object)o);
        BeanUtilsTestCase.assertEquals((String)"Juicy!", (String)o.getBrand());
        BeanUtilsTestCase.assertEquals((Object)new Double(2.32), (Object)o.getRadius());
        BeanUtilsTestCase.assertEquals((Object)new Integer(22), (Object)o.getSegments());
    }

    public void testBeanPropertiesWithFail() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("brand", "Juicy!");
        map.put("radius", "2.32");
        map.put("segments", "22");
        map.put("trombones", "3");
        Orange o = new Orange();
        try {
            BeanUtils.populate((Object)new Orange(), map);
            BeanUtilsTestCase.fail((String)"Trombones is not a valid property");
        }
        catch (IllegalArgumentException e) {
            BeanUtilsTestCase.assertTrue((e.getMessage().indexOf("trombone") > -1 ? 1 : 0) != 0);
        }
    }

    private class OrangeInvocationHandler
    implements InvocationHandler {
        private Orange orange;

        private OrangeInvocationHandler(Orange orange) {
            this.orange = orange;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.orange, args);
        }
    }
}

