/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.TemplateParser;

public class TemplateParserTestCase
extends AbstractMuleTestCase {
    public void testStringParserSquareBraces() {
        TemplateParser tp = TemplateParser.createSquareBracesStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("fromAddress", "ross.mason@symphonysoft.com");
        String string = "smtp://[fromAddress]";
        String result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)"smtp://ross.mason@symphonysoft.com", (String)result);
        string = "smtp://[toAddress]";
        result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)"smtp://[toAddress]", (String)result);
    }

    public void testStringParserAntBraces() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        String string = "Some String with ${prop1} and ${prop2} in it";
        String result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)"Some String with value1 and value2 in it", (String)result);
        string = "${prop1}${prop1}${prop2}";
        result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)"value1value1value2", (String)result);
        String homeDir = System.getProperty("user.home");
        props.put("homeDir", homeDir);
        string = "${homeDir}/foo";
        result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)(homeDir + "/foo"), (String)result);
        String whitespaceValue = "C:\\Documents and Settings\\";
        props.put("whitespaceValue", whitespaceValue);
        string = "start${whitespaceValue}end";
        result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)("start" + whitespaceValue + "end"), (String)result);
    }

    public void testListParserAntBraces() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        ArrayList<String> list = new ArrayList<String>();
        list.add("Some String with ${prop1} and ${prop2} in it");
        list.add("Some String with ${prop1} in it");
        List result = tp.parse(props, list);
        TemplateParserTestCase.assertEquals((Object)"Some String with value1 and value2 in it", result.get(0));
        TemplateParserTestCase.assertEquals((Object)"Some String with value1 in it", result.get(1));
        result = tp.parse(props, (List)null);
        TemplateParserTestCase.assertNotNull((Object)result);
        TemplateParserTestCase.assertEquals((int)0, (int)result.size());
    }

    public void testMapParserAntBraces() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value1", "Some String with ${prop1} and ${prop2} in it");
        map.put("value2", "Some String with ${prop1} in it");
        Map result = tp.parse(props, map);
        TemplateParserTestCase.assertEquals((Object)"Some String with value1 and value2 in it", result.get("value1"));
        TemplateParserTestCase.assertEquals((Object)"Some String with value1 in it", result.get("value2"));
        result = tp.parse(props, (Map)null);
        TemplateParserTestCase.assertNotNull((Object)result);
        TemplateParserTestCase.assertEquals((int)0, (int)result.size());
    }

    public void testStringParserAntBracesWithSimilarNames() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop1-2", "value2");
        String string = "Some String with ${prop1} and ${prop1-2} in it";
        String result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)"Some String with value1 and value2 in it", (String)result);
        string = "A${prop1-2}B${prop1}C${prop2}";
        result = tp.parse(props, string);
        TemplateParserTestCase.assertEquals((String)"Avalue2Bvalue1C${prop2}", (String)result);
    }
}

