/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.AbstractXStreamTransformer;
import org.mule.module.xml.transformer.DomDocumentToXml;
import org.mule.util.store.DeserializationPostInitialisable;

public class XmlToObject
extends AbstractXStreamTransformer {
    private final DomDocumentToXml domTransformer = new DomDocumentToXml();

    public XmlToObject() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Document.class);
        this.setReturnClass(Object.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object result;
        Object src = message.getPayload();
        if (src instanceof byte[]) {
            try {
                InputStreamReader xml = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])src), outputEncoding);
                result = this.getXStream().fromXML((Reader)xml);
            }
            catch (UnsupportedEncodingException e) {
                throw new TransformerException(this, (Throwable)e);
            }
        }
        if (src instanceof InputStream) {
            InputStream input = (InputStream)src;
            try {
                InputStreamReader xml = new InputStreamReader(input, outputEncoding);
                result = this.getXStream().fromXML((Reader)xml);
            }
            catch (Exception e) {
                throw new TransformerException(this, (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)"Exception closing stream: ", (Throwable)e);
                }
            }
        }
        result = src instanceof String ? this.getXStream().fromXML(src.toString()) : this.getXStream().fromXML((String)this.domTransformer.transform(src));
        try {
            this.postDeserialisationInit(result);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected void postDeserialisationInit(Object object) throws Exception {
        if (object instanceof DeserializationPostInitialisable) {
            DeserializationPostInitialisable.Implementation.init(object, this.muleContext);
        }
    }
}

