/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.module.xml.util.LocalURIResolver;
import org.mule.module.xml.util.XMLUtils;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class XsltTransformer
extends AbstractXmlTransformer {
    private static final int MIN_IDLE_TRANSFORMERS = 1;
    private static final int MAX_IDLE_TRANSFORMERS = 32;
    private static final int MAX_ACTIVE_TRANSFORMERS = 32;
    public static final String PREFERRED_TRANSFORMER_FACTORY = "net.sf.saxon.TransformerFactoryImpl";
    protected final GenericObjectPool transformerPool = new GenericObjectPool((PoolableObjectFactory)new PooledXsltTransformerFactory());
    private volatile String xslTransformerFactoryClassName = "net.sf.saxon.TransformerFactoryImpl";
    private volatile String xslFile;
    private volatile String xslt;
    private volatile Map contextProperties;
    private URIResolver uriResolver;

    public XsltTransformer() {
        this.transformerPool.setMinIdle(1);
        this.transformerPool.setMaxIdle(32);
        this.transformerPool.setMaxActive(32);
        this.uriResolver = new LocalURIResolver();
        this.contextProperties = new HashMap();
    }

    public XsltTransformer(String xslFile) {
        this();
        this.xslFile = xslFile;
    }

    public void initialise() throws InitialisationException {
        try {
            this.transformerPool.addObject();
        }
        catch (Throwable te) {
            throw new InitialisationException(te, (Initialisable)this);
        }
    }

    public Object transform(MuleMessage message, String encoding) throws TransformerException {
        Object src = message.getPayload();
        try {
            Source sourceDoc = XMLUtils.toXmlSource(this.getXMLInputFactory(), this.isUseStaxSource(), src);
            if (sourceDoc == null) {
                return null;
            }
            AbstractXmlTransformer.ResultHolder holder = XsltTransformer.getResultHolder(this.returnType.getType());
            if (holder == null) {
                holder = XsltTransformer.getResultHolder(src.getClass());
            }
            if (holder == null || DelayedResult.class.equals((Object)this.returnType)) {
                return this.getDelayedResult(message, encoding, sourceDoc);
            }
            this.doTransform(message, encoding, sourceDoc, holder.getResult());
            return holder.getResultObject();
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected Object getDelayedResult(final MuleMessage message, final String encoding, final Source sourceDoc) {
        return new DelayedResult(){
            private String systemId;

            public void write(Result result) throws Exception {
                XsltTransformer.this.doTransform(message, encoding, sourceDoc, result);
            }

            public String getSystemId() {
                return this.systemId;
            }

            public void setSystemId(String systemId) {
                this.systemId = systemId;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTransform(MuleMessage message, String encoding, Source sourceDoc, Result result) throws Exception {
        DefaultErrorListener errorListener = new DefaultErrorListener(this);
        javax.xml.transform.Transformer transformer = null;
        try {
            transformer = (javax.xml.transform.Transformer)this.transformerPool.borrowObject();
            transformer.setErrorListener(errorListener);
            transformer.setOutputProperty("encoding", encoding);
            if (this.contextProperties != null) {
                for (Map.Entry parameter : this.contextProperties.entrySet()) {
                    String key = (String)parameter.getKey();
                    transformer.setParameter(key, this.evaluateTransformParameter(key, parameter.getValue(), message));
                }
            }
            transformer.transform(sourceDoc, result);
            if (errorListener.isError()) {
                throw errorListener.getException();
            }
        }
        finally {
            if (transformer != null) {
                transformer.clearParameters();
                this.transformerPool.returnObject((Object)transformer);
            }
        }
    }

    public String getXslTransformerFactory() {
        return this.xslTransformerFactoryClassName;
    }

    public void setXslTransformerFactory(String xslTransformerFactory) {
        this.xslTransformerFactoryClassName = xslTransformerFactory;
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    protected StreamSource getStreamSource() throws InitialisationException {
        InputStream is;
        if (this.xslt != null) {
            return new StreamSource(new StringReader(this.xslt));
        }
        if (this.xslFile == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("xslFile"), (Initialisable)this);
        }
        try {
            is = IOUtils.getResourceAsStream(this.xslFile, this.getClass());
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (is != null) {
            return new StreamSource(is);
        }
        throw new InitialisationException(CoreMessages.failedToLoad(this.xslFile), (Initialisable)this);
    }

    public int getMaxActiveTransformers() {
        return this.transformerPool.getMaxActive();
    }

    public void setMaxActiveTransformers(int maxActiveTransformers) {
        this.transformerPool.setMaxActive(maxActiveTransformers);
    }

    public int getMaxIdleTransformers() {
        return this.transformerPool.getMaxIdle();
    }

    public void setMaxIdleTransformers(int maxIdleTransformers) {
        this.transformerPool.setMaxIdle(maxIdleTransformers);
    }

    public Map getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map contextProperties) {
        this.contextProperties = contextProperties;
    }

    protected Object evaluateTransformParameter(String name, Object value, MuleMessage message) throws TransformerException {
        if (value instanceof String) {
            return this.muleContext.getExpressionManager().parse(value.toString(), message);
        }
        return value;
    }

    protected class DefaultErrorListener
    implements ErrorListener {
        private TransformerException e = null;
        private final Transformer trans;

        public DefaultErrorListener(Transformer trans) {
            this.trans = trans;
        }

        public TransformerException getException() {
            return this.e;
        }

        public boolean isError() {
            return this.e != null;
        }

        public void error(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void fatalError(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void warning(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.warn((Object)exception.getMessage());
        }
    }

    protected class PooledXsltTransformerFactory
    extends BasePoolableObjectFactory {
        protected PooledXsltTransformerFactory() {
        }

        public Object makeObject() throws Exception {
            TransformerFactory factory;
            StreamSource source = XsltTransformer.this.getStreamSource();
            String factoryClassName = XsltTransformer.this.getXslTransformerFactory();
            if (XsltTransformer.PREFERRED_TRANSFORMER_FACTORY.equals(factoryClassName) && !ClassUtils.isClassOnPath(factoryClassName, ((Object)((Object)this)).getClass())) {
                XsltTransformer.this.logger.warn((Object)"Preferred Transfomer Factory net.sf.saxon.TransformerFactoryImpl not on classpath and no default is set, defaulting to JDK");
                factoryClassName = null;
            }
            if (StringUtils.isNotEmpty((String)factoryClassName)) {
                factory = (TransformerFactory)ClassUtils.instanciateClass(factoryClassName, ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
            } else {
                try {
                    factory = TransformerFactory.newInstance();
                }
                catch (TransformerFactoryConfigurationError e) {
                    System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                    factory = TransformerFactory.newInstance();
                }
            }
            factory.setURIResolver(XsltTransformer.this.getUriResolver());
            return factory.newTransformer(source);
        }
    }
}

